/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.searchFlights;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class B2BSearchFlightsParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map passengers;
        List passengerTypesWithInvalidCategory;
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        if (parameters.getRoutes().isEmpty()) {
            parameters.getValidationContext().getRoutesValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyLegs());
        }
        if (Objects.isNull(parameters.getClassOfService())) {
            parameters.getValidationContext().getClassOfServiceValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyClassOfService());
        }
        parameters.getRoutes().forEach(route -> AviaValidationHelper.validateRoute(route, minimumDate));
        if (Objects.isNull(parameters.getRouteType())) {
            parameters.getValidationContext().getRouteTypeValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyRouteType());
        }
        if (parameters.getRouteType() == RouteType.ROUNDTRIP) {
            if (parameters.getRoutes().size() != 2) {
                parameters.getValidationContext().getRoutesValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyLegs());
            } else if (((BaseRoute)parameters.getRoutes().get(1)).getDate() == null) {
                ((BaseRoute)parameters.getRoutes().get(1)).getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDate());
            } else if (((BaseRoute)parameters.getRoutes().get(1)).getDate().isBefore((ReadablePartial)((BaseRoute)parameters.getRoutes().get(0)).getDate())) {
                ((BaseRoute)parameters.getRoutes().get(1)).getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getPastDate());
            }
        }
        boolean hasPassengers = false;
        if (!parameters.getPassengers().isEmpty() && !parameters.getRoutes().isEmpty()) {
            hasPassengers = true;
            parameters.getPassengersTypes().putAll(this.calcPassengerTypesMap(parameters));
        }
        if (!(passengerTypesWithInvalidCategory = (passengers = parameters.getPassengersTypes()).keySet().stream().filter(type -> !AviaHelper.isValidPassengerTypeCategory((DictionaryReference<PassengerType>)type)).collect(Collectors.toList())).isEmpty()) {
            AviaValidationHelper.addValidationMessage(parameters, passengerTypesWithInvalidCategory::contains, SearchFlightsParametersValidationMessages.getInvalidPassengerTypeCategory());
        }
        int totalPassengers = passengers.values().stream().mapToInt(count -> count).sum();
        int adults = AviaHelper.getAdultPassengersCount(passengers);
        int youthsOrSeniors = AviaHelper.getYouthAndSeniorsCount(passengers);
        int infants = AviaHelper.getInfantPassengersCount(passengers);
        int children = AviaHelper.getChildrenPassengersCount(passengers);
        if (totalPassengers == 0) {
            parameters.getValidationContext().getPassengersValidationMessages().add(GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if (totalPassengers > 8) {
            if (hasPassengers) {
                this.addMessageToFirstPassenger(parameters, GdsValidationMessages.getSeatsTooManyPassengers());
            } else {
                AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsTooManyPassengers());
            }
        }
        if (adults <= 0 && youthsOrSeniors <= 0) {
            AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if ((adults > 0 || infants > 0 || children > 0) && youthsOrSeniors > 0) {
            AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.youthsAndSeniorsFilter, SearchFlightsParametersValidationMessages.getYouthAndSeniorDoNotCombineWithOthers());
        }
        if (adults < infants) {
            if (hasPassengers) {
                this.addMessageToFirstPassenger(parameters, SearchFlightsParametersValidationMessages.getIllegalInfantsAmount());
            } else {
                AviaValidationHelper.addValidationMessage(parameters, AviaHelper.PassengerFilters.adultsAndInfantsFilter, SearchFlightsParametersValidationMessages.getIllegalInfantsAmount());
            }
        }
        if (!hasPassengers && children > 0 && CommonHelper.getStep1Settings((EntityReference<SMSite>)siteRef).isDisplayChildAgeSelector()) {
            AviaValidationHelper.validateChildAges(parameters, children);
        }
        AviaValidationHelper.validateFlightNumbers(parameters);
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }

    private Map<DictionaryReference<PassengerType>, Integer> calcPassengerTypesMap(CommonSearchParameters restParams) {
        List persons = restParams.getPassengers();
        Object[] personUids = persons.stream().map(EntityReference::getUid).distinct().toArray();
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])personUids));
        sq.getPreferredProperties().add(PersonIndex.Property.birthday.name());
        List personIndexes = EntityStorage.get().search(PersonIndex.class, sq).getData();
        LocalDate firstDepartureDate = ((BaseRoute)restParams.getRoutes().get(0)).getDate();
        boolean existsPassengers18YearsOld = personIndexes.stream().map(PersonIndex::getBirthday).map(MiscUtil::convertToJodaLocalDate).anyMatch(localBirthDate -> localBirthDate == null || !firstDepartureDate.isBefore((ReadablePartial)localBirthDate.plusYears(18)));
        if (!existsPassengers18YearsOld) {
            this.addMessageToFirstPassenger(restParams, SearchFlightsParametersValidationMessages.getMustBeAtLeastOnePassengerOver18());
        }
        LocalDate lastDepartureDate = ((BaseRoute)restParams.getRoutes().get(restParams.getRoutes().size() - 1)).getDate();
        Map<EntityReference, DictionaryReference> passengerTypesMap = personIndexes.stream().collect(Collectors.toMap(PersonIndex::getSource, pi -> this.getPassengerType(lastDepartureDate, pi.getBirthday())));
        return persons.stream().collect(Collectors.groupingBy(passengerTypesMap::get, Collectors.collectingAndThen(Collectors.counting(), Long::intValue)));
    }

    private DictionaryReference<PassengerType> getPassengerType(LocalDate lastDepartureDate, Date birthDate) {
        if (birthDate == null || lastDepartureDate == null) {
            return DictHelper.getAdultPassengerType();
        }
        LocalDate localBirthDate = MiscUtil.convertToJodaLocalDate((Date)birthDate);
        if (lastDepartureDate.isBefore((ReadablePartial)localBirthDate.plusYears(2))) {
            return DictHelper.getInfantPassengerType();
        }
        if (lastDepartureDate.isBefore((ReadablePartial)localBirthDate.plusYears(12))) {
            return DictHelper.getChildPassengerType();
        }
        return DictHelper.getAdultPassengerType();
    }

    private void addMessageToFirstPassenger(CommonSearchParameters parameters, ValidationMessage vmes) {
        Collection messages = CollectionUtil.getOrAddList((Map)parameters.getValidationContext().getPassengersListValidationMessages(), (Object)0);
        messages.add(vmes);
    }
}

