/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BSearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchFlights.SearchFlightsResultConverter;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Messages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class B2BSearchFlightsResultConverter
extends SearchFlightsResultConverter {
    @Override
    public void process(MessageContext ctx) throws Exception {
        super.process(ctx);
        SearchFlightsResult commonResult = (SearchFlightsResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        B2BSearchFlightsResult result = new B2BSearchFlightsResult();
        result.getBestPrices().putAll(commonResult.getBestPrices());
        result.getFlights().addAll(commonResult.getFlights());
        result.setTravelPolicy(result.getFlights().stream().anyMatch(fl -> fl.getFlight().getTravelPolicyCompliance() != null));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    @Override
    protected void convertGdsFlights(MessageContext ctx, Collection<Flight> gdsFlights, PriceComponentsParameters componentsParameters, PriceDisplayStyle displayStyle, SearchFlightsResult result, Map<String, ExchangeRateData> currencyExchangeRateDataMap) {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        List passengers = (List)ctx.getObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS);
        TripParameters tripParams = (TripParameters)ctx.getObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS);
        HashMap<DictionaryReference, Object> processedAirlines = new HashMap<DictionaryReference, Object>();
        HashMap<DictionaryReference, Boolean> processedLocations = new HashMap<DictionaryReference, Boolean>();
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        SMStep2Settings step2Settings = CommonHelper.getStep2Settings((EntityReference<SMSite>)componentsParameters.getSalesContext().getSite());
        block2: for (Flight flight : gdsFlights) {
            if (CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)flight)) continue;
            DictionaryReference carrier = flight.getCarrier();
            if (carrier != null) {
                Object ps = (Boolean)processedAirlines.get(carrier);
                if (null == ps) {
                    ps = DictionaryCache.get().resolveReference(carrier) != null;
                    processedAirlines.put(carrier, ps);
                    if (!((Boolean)ps).booleanValue()) {
                        B2BRestHelper.addMessage(ctx, Messages.getNoCarrierFound((String)carrier.getCode()));
                    }
                }
                if (!((Boolean)ps).booleanValue()) continue;
            }
            for (FlightSegment fs : FlightHelper.getFlightSegmentsList((Flight)flight)) {
                Boolean ps;
                for (DictionaryReference location : Arrays.asList(fs.getLocationBegin(), fs.getLocationEnd())) {
                    ps = (Boolean)processedLocations.get(location);
                    if (null == ps) {
                        ps = DictionaryCache.get().resolveReference(location) != null;
                        processedLocations.put(location, ps);
                        if (!ps.booleanValue()) {
                            B2BRestHelper.addMessage(ctx, Messages.getNoLocationFound((String)location.getCode()));
                        }
                    }
                    if (ps.booleanValue()) continue;
                    continue block2;
                }
                for (DictionaryReference airline : Arrays.asList(fs.getAirline(), fs.getOperatingAirline())) {
                    ps = (Boolean)processedAirlines.get(airline);
                    if (null == ps) {
                        ps = DictionaryCache.get().resolveReference(airline) != null;
                        processedAirlines.put(airline, ps);
                        if (!ps.booleanValue()) {
                            B2BRestHelper.addMessage(ctx, Messages.getNoCarrierFound((String)airline.getCode()));
                        }
                    }
                    if (ps.booleanValue()) continue;
                    continue block2;
                }
            }
            if (flight.getCarrier() != null) {
                try {
                    result.getFlights().add(AviaConverterHelper.convertFlightSearchItem2Rest(flight, componentsParameters, displayStyle, false, (EntityReference<Organization>)salesContext.getClient(), passengers, tripParams, showGdsAccountName, step2Settings, currencyExchangeRateDataMap));
                }
                catch (Exception ex) {
                    IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)flight.getGdsAccount().getCaption()), IncidentsHelper.getContextStackTraceElement((String)"Flight", (String)FlightHelper.toIdentifiableString((Flight)flight))});
                    IncidentsLog.reportException((String)"failed converting flight to restFlight", (Throwable)ex);
                }
                continue;
            }
            this.log.warn(this.noValidatingCarrierWarning(flight));
        }
    }

    @Override
    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

