/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.searchFlights;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;

public class B2BSearchFlightsTravelPolicyParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean hasTravelPolicy;
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        boolean bl = hasTravelPolicy = parameters.getClient() != null;
        if (!hasTravelPolicy) {
            return;
        }
        EntityReference clientRef = parameters.getClient();
        if (TextUtil.nonBlank((String)clientRef.getUid())) {
            EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
            if (null == clientCtr) {
                parameters.getValidationContext().getClientValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidClient());
            } else {
                clientRef = clientCtr.toReference();
            }
        } else {
            parameters.getValidationContext().getClientValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidClient());
        }
        EmployeeCategory employeeCategory = null;
        for (int i = 0; i < parameters.getPassengers().size(); ++i) {
            EntityContainer personCtr;
            EntityReference personRef = (EntityReference)parameters.getPassengers().get(i);
            EntityReference<Organization> companyRef = null;
            Person person = null;
            if (TextUtil.nonBlank((String)personRef.getUid()) && (personCtr = EntityStorage.get().resolve(personRef)) != null) {
                person = (Person)personCtr.getEntity();
                PersonEmployment personEmployment = CommonValidationHelper.getPersonEmployment(person, (EntityReference<Organization>)clientRef);
                ValidationMessage validationDatesMessage = CommonValidationHelper.checkDatesForValid(personEmployment);
                if (validationDatesMessage != null) {
                    parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(validationDatesMessage);
                    continue;
                }
                companyRef = CommonValidationHelper.getEmployeeOrganization(person, (EntityReference<Organization>)clientRef);
            }
            if (!clientRef.equals(companyRef)) {
                parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidWorkPlace());
                continue;
            }
            EmployeeCategory employeeCategory2 = GeneralProductHelper.getEmployeeCategory(companyRef, person);
            if (0 == i) {
                employeeCategory = employeeCategory2;
                continue;
            }
            if (GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)employeeCategory, (EmployeeCategory)employeeCategory2)) continue;
            parameters.getValidationContext().getPassengersListValidationMessages().computeIfAbsent(i, p -> new ArrayList()).add(SearchFlightsParametersValidationMessages.getInvalidPassengerEmployeeCategory());
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

