/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.List;

public class SearchFlightValidationAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) {
        if (e instanceof ValidationException) {
            CommonSearchParameters restParameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
            FlightSearchParameters gdsParameters = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
            this.copyValidationMessages(gdsParameters, restParameters);
            if (ValidationHelper.isValid((Validatable)restParameters)) {
                throw Xeption.forDeveloper((String)this.getFirstValidationMessage(gdsParameters), (Object[])new Object[0]);
            }
        }
        return false;
    }

    private void copyValidationMessages(FlightSearchParameters gdsParameters, CommonSearchParameters restParameters) {
        this.copy(gdsParameters.getValidationContext().getPreferredAirlinesValidationMessages(), restParameters.getValidationContext().getPreferredAirlinesValidationMessages());
        this.copy(gdsParameters.getValidationContext().getServiceClassValidationMessages(), restParameters.getValidationContext().getClassOfServiceValidationMessages());
        for (int i = 0; i < gdsParameters.getRoute().size(); ++i) {
            this.copy(((RouteSegment)gdsParameters.getRoute().get(i)).getValidationContext(), ((BaseRoute)restParameters.getRoutes().get(i)).getValidationContext());
        }
    }

    private void copy(RouteSegment.RouteSegmentValidationContext vcFrom, BaseRoute.BaseRouteValidationContext vcTo) {
        this.copy(vcFrom.getDateValidationMessages(), vcTo.getDateValidationMessages());
        this.copy(vcFrom.getDepartureTimeBeginValidationMessages(), vcTo.getDepartureTimeWindowStartValidationMessages());
        this.copy(vcFrom.getDepartureTimeEndValidationMessages(), vcTo.getDepartureTimeWindowEndValidationMessages());
        this.copy(vcFrom.getLocationEndValidationMessages(), vcTo.getArrivalCodeValidationMessages());
        this.copy(vcFrom.getLocationBeginValidationMessages(), vcTo.getDepartureCodeValidationMessages());
    }

    private String getFirstValidationMessage(FlightSearchParameters gdsParameters) {
        String prefix = "params";
        List errors = ValidatableUtil.getValidateStrings((com.gridnine.xtrip.common.model.Validatable)gdsParameters);
        if (errors.isEmpty()) {
            throw Xeption.forDeveloper((String)"validation advise error", (Object[])new Object[0]);
        }
        return prefix.concat(TextUtil.join((String)"; ", (Iterable)errors));
    }

    private boolean copy(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        return ValidationHelper.copy(from, to);
    }
}

