/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.seatsMap;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AircraftDeck;
import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsRow;
import com.gridnine.xtrip.common.gds.model.TravellerAircraftSeatsMap;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.IbecorpPriceStructureHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.AircraftSeatInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.IBusRestAviaContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BPassenger;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.GetFlightSeatsMapResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.RestSeatsMap;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Messages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAircraftDeck;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestSeat;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestSeatsRow;
import com.gridnine.xtrip.server.ibecorp.model.rest.avia.RestAircraftSeatToken;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetSeatsMapResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        AircraftSeatsMap seatsMap = (AircraftSeatsMap)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP);
        Map travellersMap = (Map)ctx.getMandatoryObject((Enum)IBusRestAviaContextKeys.TRAVELLER_TO_REST_PASSENGER_MAP);
        PriceComponentsParameters priceParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
        if (seatsMap.getSeatsMapsByTravellers().isEmpty()) {
            throw Xeption.forEndUser((String)Messages.getGetSeatsMapNotAvailable().getText(), (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)this.buildResult(seatsMap, travellersMap, priceParameters));
    }

    private GetFlightSeatsMapResult buildResult(AircraftSeatsMap seatsMap, Map<Traveller, B2BPassenger> travellersMap, PriceComponentsParameters priceParameters) {
        GetFlightSeatsMapResult result = new GetFlightSeatsMapResult();
        seatsMap.getSeatsMapsByTravellers().stream().map(sm -> this.toRestSeatsMap((TravellerAircraftSeatsMap)sm, seatsMap.getSegmentId(), travellersMap, priceParameters)).forEach(result.getSeatsMaps()::add);
        return result;
    }

    private RestSeatsMap toRestSeatsMap(TravellerAircraftSeatsMap gdsSeatsMap, String segmentId, Map<Traveller, B2BPassenger> travellersMap, PriceComponentsParameters priceParameters) {
        RestSeatsMap result = new RestSeatsMap();
        result.setPassenger(travellersMap.get(gdsSeatsMap.getTraveller()));
        gdsSeatsMap.getDecks().stream().map(gdsDeck -> this.toRestAircraftDeck((AircraftDeck)gdsDeck, segmentId, priceParameters)).forEach(result.getDecks()::add);
        return result;
    }

    private RestAircraftDeck toRestAircraftDeck(AircraftDeck gdsDeck, String segmentId, PriceComponentsParameters priceParameters) {
        RestAircraftDeck result = new RestAircraftDeck();
        result.setLocation(gdsDeck.getLocation());
        gdsDeck.getSeatsRows().stream().map(gdsSeatsRow -> this.toRestSeatsRow((AircraftSeatsRow)gdsSeatsRow, segmentId, priceParameters)).forEach(result.getSeatsRows()::add);
        return result;
    }

    private RestSeatsRow toRestSeatsRow(AircraftSeatsRow gdsSeatsRow, String segmentId, PriceComponentsParameters priceParameters) {
        RestSeatsRow result = new RestSeatsRow();
        result.setNumber(gdsSeatsRow.getNumber());
        gdsSeatsRow.getSeats().stream().map(gdsSeat -> this.toRestSeat((AircraftSeat)gdsSeat, segmentId, gdsSeatsRow.getNumber(), priceParameters)).forEach(result.getSeats()::add);
        return result;
    }

    private RestSeat toRestSeat(AircraftSeat gdsSeat, String segmentId, int rowNumber, PriceComponentsParameters priceParameters) {
        RestSeat result = new RestSeat();
        result.setNumber(gdsSeat.getNumber());
        result.setNoSeat(gdsSeat.isNoSeat());
        result.setOccupied(gdsSeat.isOccupied());
        result.setPrice(CommonConverterHelper.convertMoney2Rest(IbecorpPriceStructureHelper.calculatePriceStructure((List)gdsSeat.getContractRelations()).getTotal(), priceParameters.getCurrency()));
        gdsSeat.getCharacteristics().stream().map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).filter(Objects::nonNull).filter(AircraftSeatInfo::isShowOnSite).map(AircraftSeatInfo::toReference).forEach(result.getCharacteristics()::add);
        result.getIndicators().addAll(gdsSeat.getIndicators());
        result.setToken(this.buildRestSeatToken(gdsSeat, segmentId, rowNumber));
        return result;
    }

    private String buildRestSeatToken(AircraftSeat gdsSeat, String segmentId, int rowNumber) {
        RestAircraftSeatToken token = new RestAircraftSeatToken();
        token.setSegmentId(segmentId);
        token.setRowNumber(rowNumber);
        token.getCustomProperties().addAll(gdsSeat.getCustomProperties());
        token.getContractRelations().addAll(gdsSeat.getContractRelations());
        try {
            return B2BRestHelper.encodeToken((XSSerializable)token);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"buildRestSeatToken failed", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

