/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees.RestAncillaryFeesHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BSelectFlightResult;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.selectFlight.SelectFlightResultConverter;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.FlightParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAncillaryFeeSegment;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class B2BSelectFlightResultConverter
extends SelectFlightResultConverter {
    @Override
    public void process(MessageContext ctx) throws Exception {
        FlightParameters parameters = (FlightParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        FlightDataWrapper dataWrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(parameters.getFlightToken());
        Flight oldFlight = dataWrapper.getGdsFlight();
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        PriceComponentsParameters priceParameters = this.getPriceConverterParameters(ctx);
        B2BSelectFlightResult result = this.buildSelectFlightResult(dataWrapper, oldFlight, selectedFlight, (EntityReference<SMSite>)siteRef, siteType, priceParameters);
        result.getFlight().setPrice(AviaPriceComponents.builder(selectedFlight, priceParameters).addPassengers(result.getPassengers()).build().createPrice());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected B2BSelectFlightResult buildSelectFlightResult(FlightDataWrapper dataWrapper, Flight oldFlight, Flight selectedFlight, EntityReference<SMSite> siteRef, SMSiteType siteType, PriceComponentsParameters priceParameters) throws Exception {
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings(siteRef);
        B2BSelectFlightResult result = new B2BSelectFlightResult();
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Flight restFlight = AviaConverterHelper.convertFlight2Rest(selectedFlight, priceParameters, generalSettings, true, showGdsAccountName);
        restFlight.setInternational(AviaConverterHelper.isInternationalFlight(selectedFlight));
        result.setFlight(restFlight);
        dataWrapper.setGdsFlight(selectedFlight);
        result.setFlightToken(B2BRestHelper.encodeToken((XSSerializable)dataWrapper));
        result.setSegmentsChanged(this.isSegmentsChanged(oldFlight, selectedFlight));
        List legs = result.getFlight().getLegs();
        result.getPassengers().addAll(this.getPassengers(selectedFlight, priceParameters, legs));
        return result;
    }

    @Override
    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }

    private Collection<Passenger> getPassengers(Flight flight, PriceComponentsParameters priceParameters, List<Leg> legs) {
        ArrayList<Passenger> passengers = new ArrayList<Passenger>();
        Map<Integer, RestAncillaryFeeSegment> segmentsMap = RestAncillaryFeesHelper.buildSegmentsMap(legs);
        flight.getSeats().forEach(pt -> {
            for (int i = 0; i < pt.getCount(); ++i) {
                Passenger passenger = new Passenger();
                passenger.setType(pt.getPassengerType());
                flight.getAncillaryFees().stream().map(af -> RestAncillaryFeesHelper.buildRestAncFee(af, priceParameters, segmentsMap)).forEach(passenger.getAncillaryFees()::add);
                passengers.add(passenger);
            }
        });
        return passengers;
    }
}

