/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.selectFlight;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchDuplicatesParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class FlightSearchDuplicatesParametersBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List passengers = (List)ctx.getObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS);
        SearchDuplicatesParameters result = new SearchDuplicatesParameters();
        FlightSearchParameters fsp = flight.getSearchParameters();
        LocalDate startDate = this.getLocalDateStream(fsp).min(LocalDate::compareTo).orElseThrow(() -> Xeption.forDeveloper((String)"flight start date is null", (Object[])new Object[0]));
        LocalDate endDate = this.getLocalDateStream(fsp).max(LocalDate::compareTo).orElseThrow(() -> Xeption.forDeveloper((String)"flight end date is null", (Object[])new Object[0]));
        result.setFirstTravelDate(startDate);
        result.setLastTravelDate(endDate);
        result.getTravellers().addAll(MiscUtil.guarded((Collection)passengers));
        ctx.putObject((Enum)IBusRestContextKeys.REST_PARAMS, (Object)result);
    }

    private Stream<LocalDate> getLocalDateStream(FlightSearchParameters fsp) {
        return fsp.getRoute().stream().map(RouteSegment::getDate).map(DateUtils::toLocalDate).filter(Objects::nonNull);
    }
}

