/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.sendToApprove;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.FlightOffer;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AviaSendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.List;

public class AviaCreateIntentionParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ArrayList<Traveller> availableTravellers;
        FlightDataWrapper wrapper;
        AviaSendToApproveParameters parameters = (AviaSendToApproveParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (parameters.isSendEmail()) {
            CommonValidationHelper.validationEmailMessages(parameters.getEmails(), parameters.getValidationContext().getEmailsListValidationMessages());
        }
        if (!parameters.getFlightOffers().isEmpty()) {
            wrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(((FlightOffer)parameters.getFlightOffers().get(0)).getFlightToken());
            if (wrapper.getClient() != null) {
                salesContext.setClient(wrapper.getClient());
            }
        } else {
            parameters.getValidationContext().getFlightOffersValidationMessages().add(StandardValidationMessages.getEmptyCollection());
            throw new ValidationException();
        }
        List passengers = wrapper.getPassengers();
        List seats = wrapper.getGdsFlight().getSeats();
        EntityReference bookingFile = wrapper.getBookingFile();
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        ArrayList<GdsTraveller> gdsTravellers = new ArrayList<GdsTraveller>();
        EntityContainer bfCtr = EntityStorage.get().resolve(bookingFile);
        ArrayList<Object> arrayList = availableTravellers = bfCtr != null ? new ArrayList<Traveller>(((BookingFile)bfCtr.getEntity()).getTravellers()) : new ArrayList();
        if (null == passengers || passengers.isEmpty()) {
            for (SeatPreferences seatPreferences : seats) {
                DictionaryReference type = seatPreferences.getPassengerType();
                int count = seatPreferences.getCount();
                for (int i = 0; i < count; ++i) {
                    Traveller traveller = CommonConverterHelper.getIfEmptyTraveller(travellers, availableTravellers);
                    GdsTraveller gdsTraveller = new GdsTraveller();
                    gdsTraveller.setPassengerType(type);
                    gdsTraveller.setTravellerUid(traveller.getUid());
                    gdsTravellers.add(gdsTraveller);
                }
            }
        } else {
            for (Object personRef : passengers) {
                Traveller traveller = CommonConverterHelper.getTraveller(travellers, availableTravellers, (EntityReference<Person>)personRef);
                GdsTraveller gdsTraveller = new GdsTraveller();
                DictionaryReference type = DictHelper.getAdultPassengerType();
                gdsTraveller.setPassengerType(type);
                gdsTraveller.setTravellerUid(traveller.getUid());
                gdsTravellers.add(gdsTraveller);
            }
        }
        ArrayList<GdsReservationCreationParameters> reservationCreationParameters = new ArrayList<GdsReservationCreationParameters>();
        for (FlightOffer offer : parameters.getFlightOffers()) {
            String token = offer.getFlightToken();
            FlightDataWrapper wrapper2 = AviaConverterHelper.convertRestToken2FlightDataWrapper(token);
            Flight flight = wrapper2.getGdsFlight();
            GdsReservationCreationParameters aviaParameters = new GdsReservationCreationParameters();
            aviaParameters.getGdsTravellers().addAll(gdsTravellers);
            aviaParameters.setFlight(flight);
            aviaParameters.setGdsAccount(flight.getGdsAccount());
            reservationCreationParameters.add(aviaParameters);
        }
        Customer customer = B2BRestHelper.createCustomer((Traveller)travellers.get(0), salesContext);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        if (bookingFile != null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE, (Object)bookingFile);
        }
        ctx.putObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL, (Object)Boolean.TRUE);
    }
}

