/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.model.gds.flyArystan.FlyArystanGdsAccount;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.SimpleIssue;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.flyArystan.FlyArystanHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.FinanceDocumentsData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Order;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BookingConverterHelper {
    public static EntityContainer<? extends BaseIssue> createBookingIssue(EntityContainer<BookingFile> bookingFileCtr, EntityReference<Person> authorRef, Class<? extends BaseIssue> issueClass) {
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        EntityContainer issueCtr = new EntityContainer(issueClass);
        BaseIssue issue = (BaseIssue)issueCtr.getEntity();
        issue.setAuthor(authorRef);
        issue.setBooking(bookingFileCtr.toReference());
        issue.setClient(bookingFile.getCustomerProfile());
        issue.setSubagency(BookingHelper.getSubagency((BookingFile)bookingFile));
        issue.setAgency(BookingHelper.getAgency((BookingFile)bookingFile));
        issue.setStatus(IssueStatus.NEW);
        issue.setUpdateDate(new Date());
        issue.setCreateDate(new Date());
        issue.setCreationSource(ActionSource.NEW_SITE);
        return issueCtr;
    }

    public static Order convertBookingFile2Order(EntityContainer<BookingFile> bookingFileCtr, SalesContext salesContext, EntityContainer<Person> currentUserCtr) {
        Order result = new Order();
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        result.setNumber(bookingFile.getNumber());
        result.setCreated(DateUtils.toLocalDateTime((Date)bookingFile.getCreateDate()));
        result.setNotes(bookingFile.getNotes());
        if (currentUserCtr != null) {
            try {
                result.setFinanceDocumentsData(new FinanceDocumentsData());
                if (CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_BOOKINGS_CLIENT_FINANCES)) {
                    result.getFinanceDocumentsData().setClientDocumentsCreationPossible(Boolean.valueOf(BookingConverterHelper.isFinanceDocumentsCreationPossible(bookingFileCtr, salesContext, ContractType.CLIENT)));
                    boolean hasClientFinDocs = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).anyMatch(ShipmentHelper::hasClientRelatedShipment);
                    result.getFinanceDocumentsData().setClientDocumentsCreated(Boolean.valueOf(hasClientFinDocs || BookingConverterHelper.hasExternalFinanceDocuments(bookingFileCtr)));
                }
                if (CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_BOOKINGS_SUBAGENT_FINANCES)) {
                    result.getFinanceDocumentsData().setSubagentDocumentsCreationPossible(Boolean.valueOf(BookingConverterHelper.isFinanceDocumentsCreationPossible(bookingFileCtr, salesContext, ContractType.SUBAGENCY)));
                    result.getFinanceDocumentsData().setSubagentDocumentsCreated(Boolean.valueOf(BookingHelper.getBaseProductsStream((BookingFile)bookingFile).anyMatch(ShipmentHelper::hasSubagentRelatedShipment)));
                }
                boolean addAirServiceGranted = CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_ADD_AIR_SERVICE);
                boolean addRailServiceGranted = CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_ADD_RAIL_SERVICE);
                boolean addHotelServiceGranted = CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_ADD_HOTEL_SERVICE);
                boolean addTransferServiceGranted = CabinetHelper.isGranted(IbeRestrictionGroupResources.GROUP_ADD_TRANSFER_SERVICE);
                result.setAddAirServiceAllowed(addAirServiceGranted);
                result.setAddRailServiceAllowed(addRailServiceGranted);
                result.setAddHotelServiceAllowed(addHotelServiceGranted);
                result.setAddTransferServiceAllowed(addTransferServiceGranted);
                boolean allServicesDisabled = Stream.of(addAirServiceGranted, addRailServiceGranted, addHotelServiceGranted, addTransferServiceGranted).noneMatch(Boolean::booleanValue);
                result.setAddServiceDisabled(allServicesDisabled);
                EntityContainer<? extends BaseIssue> defaultIssueCtr = BookingConverterHelper.createBookingIssue(bookingFileCtr, (EntityReference<Person>)currentUserCtr.toReference(), SimpleIssue.class);
                result.setAddCommentAllowed(IbePermissionManager.isEntityGranted(defaultIssueCtr, StandardRestrictionResourceOperations.CREATE));
            }
            catch (Exception e) {
                IncidentsLog.reportException((String)"convertBookingFile2Order failed", (Throwable)e);
            }
        }
        result.setOnline(CommonIbecorpHelper.isOnlineBookingFile((BookingFile)bookingFile));
        result.setSubagencyDoesntMatch(bookingFile.getReservations().stream().anyMatch(res -> !MiscUtil.equals((Object)salesContext.getSubagency(), (Object)res.getSubagency())));
        result.setClient(bookingFile.getCustomerProfile());
        return result;
    }

    public static boolean isFlyArystanPackage(Product mco) {
        if (!ReservationGdsNameInfoHelper.hasOnlineGdsAccountOfClass((Reservation)mco.getReservation(), FlyArystanGdsAccount.class)) {
            return false;
        }
        return AirProductHelper.getSegments((Collection)mco.getSegmentTariffs()).stream().map(Segment::getFareDetails).filter(Objects::nonNull).map(FareDetails::getPricingParameters).filter(Objects::nonNull).map(FarePricingParameters::getBrandId).map(FlyArystanHelper::getPkgCode).anyMatch(TextUtil::nonBlank);
    }

    public static List<Leg> buildRestAviaLegs(Reservation reservation, PriceComponentsParameters priceComponentsParameters) {
        return AviaConverterHelper.convertLegs2Rest(AviaConverterHelper.convertReservationSegments2Rest(reservation, priceComponentsParameters), CommonIbecorpHelper.isOnlineReservation((Reservation)reservation), false, null);
    }

    public static boolean isCreditCardPaymentType(PaymentType paymentType) {
        return paymentType.name().startsWith("CREDIT_CARD") || paymentType.name().endsWith("CREDIT_CARD") || paymentType == PaymentType.TRANSCRED_PLATRON || paymentType == PaymentType.MASTERBANKCARD_PLATRON || paymentType == PaymentType.RUSSIANSTANDARD_PLATRON || paymentType == PaymentType.RAIFFEISEN_PLATRON || paymentType == PaymentType.GATELINE_CREDIT_CARD_SPLIT || paymentType == PaymentType.GATELINE_CREDIT_CARD || paymentType == PaymentType.TESTCARD_PAYBOX || paymentType == PaymentType.EPAYKZT_PAYBOX;
    }

    public static boolean isRefundAvailable(Transfer product) {
        return product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null && ReservationGdsNameInfoHelper.containsOnlineRecordLocatorOfAnyType((Reservation)product.getReservation());
    }

    private static boolean isFinanceDocumentsCreationPossible(EntityContainer<BookingFile> bookingFile, SalesContext salesContext, ContractType contractType) {
        Map<NestedEntityReference, BaseProduct> products = BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)bookingFile.getEntity())).collect(Collectors.toMap(item -> new NestedEntityReference(bookingFile, (BaseEntity)item, BookingHelper.generateShortProductName((BaseProduct)item)), item -> item));
        return FinanceDocumentHelper.getShipmentFinanceDocumentProductDatas(products, (EntityReference)salesContext.getSubagency(), (Date)new Date()).values().stream().flatMap(Collection::stream).anyMatch(data -> data.getContractType() == contractType);
    }

    private static boolean hasExternalFinanceDocuments(EntityContainer<BookingFile> bfCtr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.bookingFile.name(), (Object)bfCtr.toReference()));
        query.getPreferredProperties().add(ExternalFinanceDocumentIndex.Property.number.name());
        query.setLimit(1);
        return !EntityStorage.get().search(ExternalFinanceDocumentIndex.class, query).getData().isEmpty();
    }
}

