/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SearchFormDataHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BookingInfoValidationHelper {
    public static void commonBookingValidate(BookingFile bookingFile, Set<Message> messages) {
        if (bookingFile.getSite() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435\u0442 \"\u0421\u0430\u0439\u0442\u0430\"", (Object[])new Object[]{bookingFile.getNumber()}));
        }
        if (CollectionUtil.isEmpty((Collection)bookingFile.getReservations())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435\u0442 \"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439\"", (Object[])new Object[]{bookingFile.getNumber()}));
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            reservation.getProducts().forEach(baseProduct -> {
                String heading = BookingInfoValidationHelper.createdHeading(baseProduct);
                if (Objects.isNull(GeneralProductHelper.getStatus((BaseProduct)baseProduct))) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0421\u0442\u0430\u0442\u0443\u0441\"", (Object[])new Object[]{heading}));
                }
                if (Objects.isNull(GeneralProductHelper.getHandler((BaseProduct)baseProduct).findIssueDate(baseProduct))) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438\"", (Object[])new Object[]{heading}));
                }
                if (baseProduct instanceof Product) {
                    BookingInfoValidationHelper.airBookingValidate((Product)baseProduct, messages, heading);
                }
                if (baseProduct instanceof RailwayProduct) {
                    BookingInfoValidationHelper.trainBookingValidate((RailwayProduct)baseProduct, messages, heading);
                }
                if (baseProduct instanceof HotelProduct) {
                    BookingInfoValidationHelper.hotelBookingValidate((HotelProduct)baseProduct, messages, heading);
                }
                if (baseProduct instanceof Transfer) {
                    BookingInfoValidationHelper.transferBookingValidate((Transfer)baseProduct, messages, heading);
                }
            });
        }
    }

    private static void airBookingValidate(Product airProduct, Set<Message> messages, String heading) {
        List segmentTariffs = airProduct.getSegmentTariffs();
        if (CollectionUtil.isEmpty((Collection)segmentTariffs)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0421\u0435\u0433\u043c\u0435\u043d\u0442\"", (Object[])new Object[]{heading}));
        } else {
            for (int i = 1; i <= segmentTariffs.size(); ++i) {
                SegmentTariff segmentTariff = (SegmentTariff)segmentTariffs.get(i - 1);
                for (Segment segment : segmentTariff.getSegments()) {
                    if (segment.getArriveLocation() == null) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041c\u0435\u0441\u0442\u043e \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                    }
                    if (segment.getDepartureLocation() == null) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041c\u0435\u0441\u0442\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                    }
                    if (TextUtil.isBlank((String)segment.getClassOfSvcCode())) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041a\u043b\u0430\u0441\u0441\"", (Object[])new Object[]{heading, i}));
                    }
                    if (TextUtil.isBlank((String)segment.getFareBasis())) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0422\u0430\u0440\u0438\u0444\"", (Object[])new Object[]{heading, i}));
                    }
                    if (segment.getAirline() == null) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\"", (Object[])new Object[]{heading, i}));
                    }
                    if (TextUtil.isBlank((String)segment.getFlightNo())) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u0420\u0435\u0439\u0441\"", (Object[])new Object[]{heading, i}));
                    }
                    if (segment.getStartDate() == null) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                    }
                    if (segment.getEndDate() != null) continue;
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                }
            }
        }
        Traveller traveller = airProduct.getTraveller();
        if (traveller == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\"", (Object[])new Object[]{heading}));
        } else {
            BookingInfoValidationHelper.passengersValidation((BaseProduct)airProduct, traveller, messages, 1, heading, true, true);
        }
    }

    private static void trainBookingValidate(RailwayProduct railwayProduct, Set<Message> messages, String heading) {
        List segments = railwayProduct.getSegments();
        if (CollectionUtil.isEmpty((Collection)segments)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0421\u0435\u0433\u043c\u0435\u043d\u0442\"", (Object[])new Object[]{heading}));
        } else {
            for (int i = 1; i <= segments.size(); ++i) {
                RailwaySegment segment = (RailwaySegment)segments.get(i - 1);
                if (TextUtil.isBlank((String)segment.getArrivalLocation())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041c\u0435\u0441\u0442\u043e \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                }
                if (TextUtil.isBlank((String)segment.getDepartureLocation())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041c\u0435\u0441\u0442\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                }
                if (TextUtil.isBlank((String)segment.getTrainNumber())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u043e\u0435\u0437\u0434\"", (Object[])new Object[]{heading, i}));
                }
                if (TextUtil.isBlank((String)segment.getCarriageNumber())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0412\u0430\u0433\u043e\u043d\"", (Object[])new Object[]{heading, i}));
                }
                if (segment.getCarriageType() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0422\u0438\u043f\"", (Object[])new Object[]{heading, i}));
                }
                if (segment.getPlaces().size() == 0) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041c\u0435\u0441\u0442\u043e\"", (Object[])new Object[]{heading, i}));
                }
                if (segment.getLocalArriveDate() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f\"", (Object[])new Object[]{heading, i}));
                }
                if (segment.getLocalDepartureDate() != null) continue;
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\"", (Object[])new Object[]{heading, i}));
            }
        }
        List travellers = railwayProduct.getPassengers();
        if (CollectionUtil.isEmpty((Collection)travellers)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\"", (Object[])new Object[]{heading}));
        } else {
            for (int i = 1; i <= travellers.size(); ++i) {
                Traveller traveller = (Traveller)travellers.get(i - 1);
                BookingInfoValidationHelper.passengersValidation((BaseProduct)railwayProduct, traveller, messages, i, heading, true, true);
            }
        }
    }

    private static void hotelBookingValidate(HotelProduct hotelProduct, Set<Message> messages, String heading) {
        if (SearchFormDataHelper.getHotelCity((DictionaryReference<GeoLocation>)hotelProduct.getHotelLocation()) == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0413\u043e\u0440\u043e\u0434\"", (Object[])new Object[]{heading}));
        }
        if (TextUtil.isBlank((String)hotelProduct.getHotelName())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041e\u0442\u0435\u043b\u044c\"", (Object[])new Object[]{heading}));
        }
        if (hotelProduct.getIssueDate() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438\"", (Object[])new Object[]{heading}));
        }
        if (TextUtil.isBlank((String)hotelProduct.getHotelAddress())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0410\u0434\u0440\u0435\u0441\"", (Object[])new Object[]{heading}));
        }
        if (CollectionUtil.isEmpty((Collection)hotelProduct.getRooms())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041d\u043e\u043c\u0435\u0440\"", (Object[])new Object[]{heading}));
        } else {
            hotelProduct.getRooms().forEach(room -> {
                if (TextUtil.isBlank((String)room.getRoomName())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\" \u043d\u043e\u043c\u0435\u0440\u0430", (Object[])new Object[]{heading}));
                }
                if (Objects.isNull(room.getBasePrice()) || MiscUtil.isZero((BigDecimal)room.getBasePrice().getValue(), (boolean)true)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \u0446\u0435\u043d\u0430 \"\u0422\u0430\u0440\u0438\u0444\u0430\"", (Object[])new Object[]{heading}));
                }
                if (room.getCheckInDate() == null || room.getCheckOutDate() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \u0434\u0430\u0442\u0430 \"\u0417\u0430\u0435\u0437\u0434\u0430\" \u0438\u043b\u0438 \"\u0412\u044b\u0435\u0437\u0434\u0430\"", (Object[])new Object[]{heading}));
                }
            });
        }
        List travellers = hotelProduct.getTravellers();
        if (travellers.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\"", (Object[])new Object[]{heading}));
        } else {
            for (int i = 1; i <= travellers.size(); ++i) {
                Traveller traveller = (Traveller)travellers.get(i - 1);
                BookingInfoValidationHelper.passengersValidation((BaseProduct)hotelProduct, traveller, messages, i, heading, false, false);
            }
        }
    }

    private static void passengersValidation(BaseProduct product, Traveller traveller, Set<Message> messages, int number, String heading, boolean checkName, boolean checkPassport) {
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        if (productHandler.getStatus(product) == ProductStatus.INTENTION || productHandler.getStatus(product) == ProductStatus.VOID_INTENTION) {
            return;
        }
        if (productHandler.getPassengerType(product, traveller) == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0422\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430\"", (Object[])new Object[]{heading, number}));
        }
        if (checkName && TextUtil.isBlank((String)traveller.getName())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0424.\u0418.\u041e\"", (Object[])new Object[]{heading, number}));
        }
        if (checkPassport) {
            Passport passport = traveller.getPassport();
            if (passport == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0430\u0441\u043f\u043e\u0440\u0442\"", (Object[])new Object[]{heading, number}));
            } else {
                if (TextUtil.isBlank((String)passport.getNumber())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041d\u043e\u043c\u0435\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430\"", (Object[])new Object[]{heading, number}));
                }
                if (TextUtil.isBlank((String)passport.getLastName())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0424\u0430\u043c\u0438\u043b\u0438\u044f \u0432 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0435\"", (Object[])new Object[]{heading, number}));
                }
                if (TextUtil.isBlank((String)passport.getFirstName())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \"\u0418\u043c\u044f \u0432 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0435\"", (Object[])new Object[]{heading, number}));
                }
                if (passport.getBirthday() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u043b\u0430\u0441\u044c \"\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0435\"", (Object[])new Object[]{heading, number}));
                }
                if (passport.getExpired() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u0443 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {1} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430\"", (Object[])new Object[]{heading, number}));
                }
            }
        }
    }

    private static void transferBookingValidate(Transfer transferProduct, Set<Message> messages, String heading) {
        if (transferProduct.getStatus() != ProductStatus.INTENTION && transferProduct.getStatus() != ProductStatus.VOID_INTENTION) {
            List travellers;
            if (TextUtil.isBlank((String)transferProduct.getSystemNumber())) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u043e\u043c\u0435\u0440 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d", (Object[])new Object[]{heading}));
            }
            if ((travellers = transferProduct.getTravellers()).isEmpty()) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"{0} \u043d\u0435 \u043d\u0430\u0448\u0435\u043b\u0441\u044f \"\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\"", (Object[])new Object[]{heading}));
            }
        }
    }

    private static String createdHeading(BaseProduct baseProduct) {
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)baseProduct);
        String recordLocator = baseProduct.getReservation() == null ? null : CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProduct.getReservation());
        String systemNumber = GeneralProductHelper.getSystemNumber((BaseProduct)baseProduct);
        return "\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435: \"" + (String)MiscUtil.guarded((Object)recordLocator, (Object)"?") + " | " + status + " \u2116 " + (String)MiscUtil.guarded((Object)systemNumber, (Object)"?") + " :: ";
    }

    public static void createdLog(EntityContainer<BookingFile> bookingFileCtr, Set<Message> messages) {
        StringBuilder sb = new StringBuilder();
        messages.forEach(message -> sb.append(message.getMessage()).append("\n"));
        SysLogHelper.audit((EntityReference)bookingFileCtr.toReference(), (String)"View product", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)"fill product", (String)sb.toString(), (Object[])new Object[0])});
    }
}

