/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class CheckBookingFileB2CPermissionsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityReference agentRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        this.checkPermissions(salesContext, booking);
        if (agentRef != null) {
            boolean granted;
            boolean bl = granted = MiscUtil.equals((Object)booking.getCustomer().getProfile(), (Object)agentRef) && MiscUtil.equals((Object)booking.getSite(), (Object)salesContext.getSite());
            if (!granted) {
                throw Xeption.forDeveloper((String)"booking file {0} is denied for b2c login {1}", (Object[])new Object[]{booking.getNumber(), UserData.get().getCurrentUser()});
            }
        }
    }

    private void checkPermissions(SalesContext salesContext, BookingFile booking) {
        boolean isValid;
        Reservation reservation = (Reservation)booking.getReservations().get(0);
        boolean bl = isValid = this.isValidBookingFile(salesContext, booking) && this.isValidReservation(salesContext, reservation);
        if (!isValid) {
            throw Xeption.forEndUser((String)"Invalid permissions for booking file {0}", (Object[])new Object[]{booking.getNumber()});
        }
    }

    private boolean isValidReservation(SalesContext salesContext, Reservation reservation) {
        return MiscUtil.equals((Object)reservation.getSubagency(), (Object)salesContext.getSubagency()) && MiscUtil.equals((Object)reservation.getSalesPoint(), (Object)salesContext.getSalesPoint()) && MiscUtil.equals((Object)reservation.getBookingAgent(), (Object)salesContext.getAgent());
    }

    private boolean isValidBookingFile(SalesContext salesContext, BookingFile bookingFile) {
        return MiscUtil.equals((Object)bookingFile.getSite(), (Object)salesContext.getSite()) && MiscUtil.equals((Object)bookingFile.getAgency(), (Object)salesContext.getAgency()) && MiscUtil.equals((Object)bookingFile.getCustomerProfile(), (Object)salesContext.getClient());
    }
}

