/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.AcceptProductDuplicatesMessageIdSupplier;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public final class IbecorpBookingFileReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SalesContext salesContexts = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservationsCtx = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATIONS);
        Reservation reservationCtx = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ReasonCode reasonCode = (ReasonCode)ctx.getObject((Enum)IBusIbecorpContextKeys.REASON_CODE);
        Map externalSystems = (Map)ctx.getObject((Enum)IBusIbecorpContextKeys.EXTERNAL_SYSTEMS);
        BaseRestEntity restParams = (BaseRestEntity)ctx.getObject((Enum)IBusRestContextKeys.REST_PARAMS);
        HashSet<Reservation> reservations = new HashSet<Reservation>();
        if (Objects.nonNull(reservationsCtx)) {
            reservations.addAll(reservationsCtx);
        }
        if (Objects.nonNull(reservationCtx)) {
            reservations.add(reservationCtx);
        }
        reservations.forEach(reservation -> {
            reservation.setOnline(true);
            reservation.setReasonCode(reasonCode);
            if (restParams instanceof AcceptProductDuplicatesMessageIdSupplier) {
                AcceptProductDuplicatesMessageIdSupplier acceptProductDuplicatesParams = (AcceptProductDuplicatesMessageIdSupplier)restParams;
                reservation.setProductDuplicatesMessageAccepted(TextUtil.nonBlank((String)acceptProductDuplicatesParams.getAcceptProductDuplicatesMessageId()));
            }
        });
        if (Objects.isNull(((BookingFile)bookingFile.getEntity()).getSite()) && Objects.nonNull(salesContexts.getSite())) {
            ((BookingFile)bookingFile.getEntity()).setSite(salesContexts.getSite());
        }
        if (externalSystems != null) {
            externalSystems.forEach((system, code) -> {
                ExternalSystemCodeV2 externalSystemCode = new ExternalSystemCodeV2();
                externalSystemCode.setSystem(system);
                externalSystemCode.setCode(code);
                ((BookingFile)bookingFile.getEntity()).getExternalCodes().add(externalSystemCode);
            });
        }
    }
}

