/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.OrderProductsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashSet;

public class OrderProductsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderProductsParameters parameters = (OrderProductsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = EntityStorage.get().resolve(parameters.getBooking());
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        HashSet<String> reservationUids = new HashSet<String>();
        HashSet<Reservation> reservations = new HashSet<Reservation>();
        ArrayList relatedProductList = new ArrayList();
        for (BaseProduct bp : BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity()))) {
            if (!parameters.getProductUids().contains(bp.getUid())) continue;
            products.add(bp);
            reservationUids.add(bp.getReservation().getUid());
            reservations.add(bp.getReservation());
            if (!AirProductHelper.isAirProduct((BaseProduct)bp)) continue;
            relatedProductList.addAll(AirProductHelper.getMcoByRelatedProduct((Product)((Product)bp)));
        }
        if (!products.containsAll(relatedProductList)) {
            throw Xeption.forDeveloper((String)"Request doesn't contain all related products of main product", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingCtr);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS, reservationUids);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS, reservations);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, products);
    }
}

