/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.BookingFormOrganizationCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.OrganizationRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.PersonRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestCostCodeCategoryUid;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployeeOrganizationCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestEmployeeCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestEmployeeCostCodeValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.site.ControlType;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.CostCodesValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class RestBookingHelper {
    public static BiPredicate<CostCode, PersonRestCostCode> REST_PERSON_COST_CODE_VALUES_EQUATOR = (cc, rcc) -> MiscUtil.equals((Object)rcc.getValue(), (Object)CorporateClientHelper.defineValueFromCostCode(cc));
    public static BiPredicate<CostCode, RestEmployeeCostCode> REST_EMPLOYEE_COST_CODE_VALUES_EQUATOR = (cc, rcc) -> rcc.getValue() != null && (MiscUtil.equals((Object)rcc.getValue().getEnglishValue(), (Object)cc.getEnglishValue()) || MiscUtil.equals((Object)rcc.getValue().getEnglishValue(), (Object)cc.getValue()) || MiscUtil.equals((Object)rcc.getValue().getLocalValue(), (Object)cc.getLocalValue()));

    public static List<BookingFormOrganizationCostCode> getOrganizationCostCodes(EntityContainer<Organization> clientCtr, RestTraveller restTraveller) {
        if (clientCtr == null) {
            return Collections.emptyList();
        }
        return RestBookingHelper.getOrganizationCostCodes((Organization)clientCtr.getEntity(), restTraveller == null ? null : restTraveller.getCostCodes());
    }

    private static List<BookingFormOrganizationCostCode> getOrganizationCostCodes(Organization org, List<PersonRestCostCode> personCostCodes) {
        return RestBookingHelper.getOrganizationCostCodes(org, personCostCodes, filter -> true, REST_PERSON_COST_CODE_VALUES_EQUATOR, BookingFormOrganizationCostCode::new, BookingFormOrganizationCostCode::getValues, CorporateClientHelper::defineValueFromCostCode);
    }

    public static List<EmployeeOrganizationCostCode> getEmployeeOrganizationCostCodes(Organization org, List<RestEmployeeCostCode> personCostCodes) {
        return RestBookingHelper.getOrganizationCostCodes(org, personCostCodes, CostCodeProperties::isPassengerUdid, REST_EMPLOYEE_COST_CODE_VALUES_EQUATOR, EmployeeOrganizationCostCode::new, EmployeeOrganizationCostCode::getValues, RestBookingHelper::getEmployeeCostCodeValue);
    }

    public static RestEmployeeCostCodeValue getEmployeeCostCodeValue(CostCode costCode) {
        RestEmployeeCostCodeValue value = new RestEmployeeCostCodeValue();
        value.setEnglishValue((String)MiscUtil.guarded((Object)costCode.getEnglishValue(), (Object)costCode.getValue()));
        value.setLocalValue(costCode.getLocalValue());
        return value;
    }

    private static <RCU extends RestCostCodeCategoryUid, RCC extends OrganizationRestCostCode> List<RCC> getOrganizationCostCodes(Organization org, List<RCU> personCostCodes, Predicate<CostCodeProperties> costCodesFilter, BiPredicate<CostCode, RCU> sameCostCode, Supplier<RCC> createOrgCostCode, Function<RCC, List> getRestCostCodeValues, Function<CostCode, Object> convertCostCodeValue) {
        Date now = new Date();
        List costCodesProperties = org.getCostCodeProperties();
        List orgCostCodes = org.getCostCodes();
        List restCostCodes = costCodesProperties.stream().filter(codeProperties -> codeProperties.getCategory() != null).filter(costCodesFilter).filter(ccp -> StatisticsHelper.testCostCodeProperties((CostCodeProperties)ccp, (List)orgCostCodes, (List)personCostCodes, (Date)now, (cc, pcc) -> MiscUtil.equals((Object)pcc.getCostCodeCategoryUid(), (Object)DictHelper.getCode((DictionaryReference)cc.getCostCodeProperties().getCategory())), (BiPredicate)sameCostCode)).map(costCodeProperties -> {
            OrganizationRestCostCode restCostCode = (OrganizationRestCostCode)createOrgCostCode.get();
            restCostCode.setName(costCodeProperties.getName());
            restCostCode.setCostCodeCategoryUid(costCodeProperties.getCategory().getCode());
            restCostCode.setCommon(costCodeProperties.isCommon());
            return restCostCode;
        }).collect(Collectors.toList());
        orgCostCodes.forEach(costCode -> {
            boolean hasRelatedCostCodes;
            String costCodeValue = CorporateClientHelper.defineValueFromCostCode(costCode);
            boolean bl = hasRelatedCostCodes = !costCode.getRelatedCostCodeProperties().isEmpty();
            if (TextUtil.nonBlank((String)costCodeValue)) {
                String categoryUid = costCode.getCostCodeProperties().getCategory().getCode();
                restCostCodes.stream().filter(RestBookingHelper.filterServiceCostCodes()).filter(rcc -> categoryUid.equals(rcc.getCostCodeCategoryUid())).findFirst().ifPresent(rcc -> {
                    if (!rcc.hasDependantCostCodes()) {
                        rcc.setDependantCostCodes(hasRelatedCostCodes);
                    }
                    ((List)getRestCostCodeValues.apply(rcc)).add(convertCostCodeValue.apply((CostCode)costCode));
                });
            }
        });
        restCostCodes.stream().filter(RestBookingHelper.filterServiceCostCodes()).forEach(rcc -> {
            if (((List)getRestCostCodeValues.apply(rcc)).size() > 0) {
                rcc.setControlType(ControlType.SELECT.name());
            } else {
                rcc.setControlType(ControlType.TEXT.name());
            }
        });
        return restCostCodes;
    }

    private static Predicate<OrganizationRestCostCode> filterServiceCostCodes() {
        return rcc -> !ControlType.SERVICE.name().equals(rcc.getControlType());
    }

    public static void validateRestCodeCodes(List<PersonRestCostCode> restCostCodes, Organization client) {
        List<BookingFormOrganizationCostCode> expectedCostCodes = RestBookingHelper.getOrganizationCostCodes(client, restCostCodes);
        if (CollectionUtil.isEmpty(restCostCodes) && CollectionUtil.isEmpty(expectedCostCodes)) {
            return;
        }
        for (PersonRestCostCode restCostCode : restCostCodes) {
            OrganizationRestCostCode expectedCostCode = (OrganizationRestCostCode)expectedCostCodes.stream().filter(ecc -> MiscUtil.equals((Object)ecc.getCostCodeCategoryUid(), (Object)restCostCode.getCostCodeCategoryUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Expected costCodes hasn't category {0}", (Object[])new Object[]{restCostCode.getCostCodeCategoryUid()}));
            RestBookingHelper.validateRestCostCode(restCostCode, client);
            expectedCostCodes.remove(expectedCostCode);
        }
        if (!expectedCostCodes.isEmpty()) {
            throw Xeption.forDeveloper((String)"there are no costCodes {0}", (Object[])new Object[]{expectedCostCodes.stream().map(OrganizationRestCostCode::getCostCodeCategoryUid).collect(Collectors.toList())});
        }
    }

    private static void validateRestCostCode(PersonRestCostCode restCostCode, Organization client) {
        CostCodeCategory category = (CostCodeCategory)DictionaryCache.get().findByCode(CostCodeCategory.class, restCostCode.getCostCodeCategoryUid());
        if (category == null) {
            restCostCode.getValidationContext().getCostCodeCategoryUidValidationMessages().add(CostCodesValidationMessages.getNoCostCategoryAtDictionary((String)restCostCode.getName()));
        }
        if (TextUtil.isBlank((String)restCostCode.getValue())) {
            restCostCode.getValidationContext().getValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValue());
        } else {
            CostCodeProperties props = CorporateClientHelper.getCostCodeProperties((RestCostCodeCategoryUid)restCostCode, client);
            List costCodes = client.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeProperties(), (Object)props)).collect(Collectors.toList());
            if (!costCodes.isEmpty()) {
                boolean noValue = costCodes.stream().noneMatch(cc -> REST_PERSON_COST_CODE_VALUES_EQUATOR.test((CostCode)cc, restCostCode));
                if (noValue) {
                    restCostCode.getValidationContext().getValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValue());
                }
            } else if (!CommonHelper.validationMaskUdids(() -> ((CostCodeProperties)props).getMask(), restCostCode.getValue())) {
                restCostCode.getValidationContext().getValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValueMask((String)props.getMask()));
            }
        }
    }

    public static void validateRestEmployeeCodeCodes(List<RestEmployeeCostCode> restCostCodes, Organization client) {
        List<EmployeeOrganizationCostCode> expectedCostCodes = RestBookingHelper.getEmployeeOrganizationCostCodes(client, restCostCodes);
        if (CollectionUtil.isEmpty(restCostCodes) && CollectionUtil.isEmpty(expectedCostCodes)) {
            return;
        }
        for (RestEmployeeCostCode restCostCode : restCostCodes) {
            OrganizationRestCostCode expectedCostCode = (OrganizationRestCostCode)expectedCostCodes.stream().filter(ecc -> MiscUtil.equals((Object)ecc.getCostCodeCategoryUid(), (Object)restCostCode.getCostCodeCategoryUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Expected costCodes hasn't category {0}", (Object[])new Object[]{restCostCode.getCostCodeCategoryUid()}));
            RestBookingHelper.validateRestEmployeeCostCode(restCostCode, client);
            expectedCostCodes.remove(expectedCostCode);
        }
        if (!expectedCostCodes.isEmpty()) {
            throw Xeption.forDeveloper((String)"there are no costCodes {0}", (Object[])new Object[]{expectedCostCodes.stream().map(OrganizationRestCostCode::getCostCodeCategoryUid).collect(Collectors.toList())});
        }
    }

    private static void validateRestEmployeeCostCode(RestEmployeeCostCode restCostCode, Organization client) {
        RestEmployeeCostCodeValue restCostCodeValue;
        CostCodeCategory category = (CostCodeCategory)DictionaryCache.get().findByCode(CostCodeCategory.class, restCostCode.getCostCodeCategoryUid());
        if (category == null) {
            restCostCode.getValidationContext().getCostCodeCategoryUidValidationMessages().add(CostCodesValidationMessages.getNoCostCategoryAtDictionary((String)restCostCode.getName()));
        }
        if ((restCostCodeValue = restCostCode.getValue()) == null) {
            restCostCode.getValidationContext().getValueValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            if (TextUtil.isBlank((String)restCostCodeValue.getLocalValue())) {
                restCostCodeValue.getValidationContext().getLocalValueValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
            if (TextUtil.isBlank((String)restCostCodeValue.getEnglishValue())) {
                restCostCodeValue.getValidationContext().getEnglishValueValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
            if (TextUtil.nonBlank((String)restCostCodeValue.getLocalValue()) && TextUtil.nonBlank((String)restCostCodeValue.getEnglishValue())) {
                CostCodeProperties props = CorporateClientHelper.getCostCodeProperties((RestCostCodeCategoryUid)restCostCode, client);
                List costCodes = client.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeProperties(), (Object)props)).collect(Collectors.toList());
                if (!costCodes.isEmpty()) {
                    boolean noValue = costCodes.stream().noneMatch(cc -> REST_EMPLOYEE_COST_CODE_VALUES_EQUATOR.test((CostCode)cc, restCostCode));
                    if (noValue) {
                        restCostCodeValue.getValidationContext().getLocalValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValue());
                    }
                } else {
                    if (!restCostCodeValue.getLocalValue().matches("([0-9\u0410-\u042f\u0430-\u044f\u0401\u0451 -])*")) {
                        restCostCodeValue.getValidationContext().getLocalValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValue());
                    } else if (!CommonHelper.validationMaskUdids(() -> ((CostCodeProperties)props).getMask(), restCostCodeValue.getLocalValue())) {
                        restCostCodeValue.getValidationContext().getLocalValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValueMask((String)props.getMask()));
                    }
                    if (!restCostCodeValue.getEnglishValue().matches("[a-zA-Z0-9-]*")) {
                        restCostCodeValue.getValidationContext().getEnglishValueValidationMessages().add(GdsValidationMessages.getAllowedLatinLettersAndDigitsOnly());
                    } else if (!CommonHelper.validationMaskUdids(() -> ((CostCodeProperties)props).getMask(), restCostCodeValue.getEnglishValue())) {
                        restCostCodeValue.getValidationContext().getEnglishValueValidationMessages().add(CostCodesValidationMessages.getIllegalCostCodeValueMask((String)props.getMask()));
                    }
                }
            }
        }
    }

    public static void validateRestCommonCostCodes(List<? extends RestTraveller> travellers, Organization client, EntityContainer<BookingFile> bfCtr) {
        List commonCodes = client.getCostCodeProperties().stream().filter(CostCodeProperties::isCommon).filter(ccp -> ccp.getCategory() != null).map(ccp -> ccp.getCategory().getCode()).collect(Collectors.toList());
        if (commonCodes.isEmpty()) {
            return;
        }
        HashMap commonRestValues = new HashMap();
        for (RestTraveller restTraveller : travellers) {
            restTraveller.getCostCodes().stream().filter(cc -> commonCodes.contains(cc.getCostCodeCategoryUid())).forEach(cc -> commonRestValues.computeIfAbsent(cc.getCostCodeCategoryUid(), k -> new HashSet()).add(cc.getValue()));
        }
        if (commonRestValues.isEmpty()) {
            return;
        }
        HashMap commonBfValues = new HashMap();
        if (bfCtr != null) {
            Set set = ((BookingFile)bfCtr.getEntity()).getReservations().stream().filter(r -> !r.isProposal()).flatMap(r -> r.getProducts().stream()).collect(Collectors.toSet());
            for (BaseProduct product : set) {
                StatisticalData statisticalData;
                ProductHandler handler = ProductHandler.of((BaseProduct)product);
                if (TicketType.FAKE == handler.getTicketType(product) || (statisticalData = handler.getStatisticalData(product)) == null) continue;
                List costCodes = statisticalData.getTravellerCostCodes().stream().flatMap(tcc -> tcc.getCostCodes().stream()).collect(Collectors.toList());
                costCodes.stream().filter(cc -> cc.getCostCodeProperties() != null && cc.getCostCodeProperties().getCategory() != null && commonCodes.contains(cc.getCostCodeProperties().getCategory().getCode())).forEach(cc -> commonBfValues.computeIfAbsent(cc.getCostCodeProperties().getCategory().getCode(), k -> new HashSet()).addAll(Arrays.asList(cc.getValue(), cc.getLocalValue(), cc.getEnglishValue())));
            }
        }
        for (Map.Entry entry : commonRestValues.entrySet()) {
            Set bfValues;
            boolean illegal = false;
            String code = (String)entry.getKey();
            Set restValues = (Set)entry.getValue();
            if (restValues.size() > 1) {
                illegal = true;
            }
            if ((bfValues = (Set)commonBfValues.get(code)) != null) {
                bfValues = bfValues.stream().filter(TextUtil::nonBlank).collect(Collectors.toSet());
                if (restValues.stream().noneMatch(bfValues::contains)) {
                    illegal = true;
                }
            }
            if (!illegal) continue;
            travellers.forEach(p -> p.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeCategoryUid(), (Object)code)).forEach(cc -> cc.getValidationContext().getValueValidationMessages().add(CostCodesValidationMessages.getIllegalCommonCostCodeValue())));
        }
    }
}

