/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees.RestAncillaryFeesHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAncillaryFeeSegment;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BookingReservationParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestTravellerAncillaryFees;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BookingAncillaryFeesResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        BookingReservationParameters parameters = (BookingReservationParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Map productFees = (Map)ctx.getObject((Enum)IBusMidofficeContextKeys.PRODUCT_ANCILLARY_FEES);
        boolean existsWrongReservation = productFees.keySet().stream().anyMatch(pr -> !MiscUtil.equals((Object)pr.getReservation().getUid(), (Object)parameters.getReservationUid()));
        if (existsWrongReservation) {
            throw Xeption.forDeveloper((String)"Wrong uid reservation", (Object[])new Object[0]);
        }
        PriceComponentsParameters priceParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, this.buildResult(productFees, priceParameters));
    }

    private List<RestTravellerAncillaryFees> buildResult(Map<Product, Collection<AncillaryFee>> productFees, PriceComponentsParameters priceParameters) {
        if (CollectionUtil.isEmptyMap(productFees)) {
            return Collections.emptyList();
        }
        Reservation res = productFees.keySet().iterator().next().getReservation();
        Map<Integer, RestAncillaryFeeSegment> segmentsMap = this.buildSegmentMap(res, priceParameters);
        ArrayList<RestTravellerAncillaryFees> result = new ArrayList<RestTravellerAncillaryFees>();
        productFees.forEach((product, gdsFees) -> {
            RestTravellerAncillaryFees restTravellerAncillaryFees = new RestTravellerAncillaryFees();
            restTravellerAncillaryFees.setTravellerUid(product.getTraveller().getUid());
            gdsFees.stream().map(fee -> RestAncillaryFeesHelper.buildRestAncFee(fee, priceParameters, segmentsMap)).forEach(restTravellerAncillaryFees.getAncillaryFees()::add);
            result.add(restTravellerAncillaryFees);
        });
        return result;
    }

    private Map<Integer, RestAncillaryFeeSegment> buildSegmentMap(Reservation res, PriceComponentsParameters priceParameters) {
        List<Leg> legs = BookingConverterHelper.buildRestAviaLegs(res, priceParameters);
        return RestAncillaryFeesHelper.buildSegmentsMap(legs);
    }
}

