/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.IbecorpPriceStructureHelper;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFeeType;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestTravellerAncillaryFees;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BookingRailAncillaryFeesResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Map productFees = (Map)ctx.getObject((Enum)IBusMidofficeContextKeys.PRODUCT_ANCILLARY_FEES);
        PriceComponentsParameters priceParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, this.buildResult(productFees, priceParameters));
    }

    private List<RestTravellerAncillaryFees> buildResult(Map<RailwayProduct, Collection<RailwayAncillaryFee>> productFees, PriceComponentsParameters priceParameters) {
        if (CollectionUtil.isEmptyMap(productFees)) {
            return Collections.emptyList();
        }
        ArrayList<RestTravellerAncillaryFees> result = new ArrayList<RestTravellerAncillaryFees>();
        productFees.forEach((product, gdsFees) -> {
            RestTravellerAncillaryFees restTravellerAncillaryFees = new RestTravellerAncillaryFees();
            restTravellerAncillaryFees.setProductUid(product.getUid());
            product.getPassengerTypes().stream().filter(pt -> pt.getTraveller() != null).filter(pt -> DictHelper.isAdultPassengerTypeCategory((DictionaryReference)pt.getPassengerType())).findFirst().ifPresent(pt -> restTravellerAncillaryFees.setTravellerUid(pt.getTraveller().getUid()));
            gdsFees.stream().map(fee -> this.buildRestAncillaryFee((RailwayAncillaryFee)fee, priceParameters)).forEach(restTravellerAncillaryFees.getAncillaryFees()::add);
            result.add(restTravellerAncillaryFees);
        });
        return result;
    }

    private RestRailAncillaryFee buildRestAncillaryFee(RailwayAncillaryFee fee, PriceComponentsParameters priceParameters) {
        RestRailAncillaryFee result = new RestRailAncillaryFee();
        result.setTravelSubject(TravelSubject.RAILWAY);
        result.setGdsId(fee.getGdsId());
        result.setType(this.convertToRestType(fee.getMcoCategory()));
        result.setMcoCategory(fee.getMcoCategory());
        result.setDescription(fee.getName());
        result.setTooltip(fee.getGdsDescription());
        Integer maxQuantity = (Integer)MiscUtil.guarded((Object)fee.getMaxQuantityPerPassenger(), (Object)1);
        result.setMaxQuantityPerPassenger(maxQuantity - MiscUtil.guarded((Integer)fee.getQuantity()));
        if (fee.getEquivalentAmount() != null) {
            result.setPrice(CommonConverterHelper.convertMoney2Rest(IbecorpPriceStructureHelper.calculatePriceStructure((BaseAncillaryFee)fee).getTotal(), priceParameters.getCurrency()));
        }
        return result;
    }

    private RestAncillaryFeeType convertToRestType(RailwayMcoCategory mcoCategory) {
        if (mcoCategory == RailwayMcoCategory.MEAL) {
            return RestAncillaryFeeType.MEALS;
        }
        if (RailwayHelper.BAGGAGE_MCO_CATEGORIES.contains(mcoCategory)) {
            return RestAncillaryFeeType.BAGGAGE;
        }
        return null;
    }
}

