/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsExpandReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsExpandReservationTraveller;
import com.gridnine.xtrip.common.midoffice.model.BaseExpandReservationParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees.RestAncillaryFeesHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.AddBookingAncillaryFeesParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestTravellerAncillaryFees;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;

public class PrepareExpandReservationParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        AddBookingAncillaryFeesParameters parameters = (AddBookingAncillaryFeesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ctx.putObject((Enum)IBusMidofficeContextKeys.EXPAND_RESERVATIONS_PARAMETERS, this.buildParams(parameters));
    }

    private List<BaseExpandReservationParameters> buildParams(AddBookingAncillaryFeesParameters restParams) {
        GdsExpandReservationParameters gdsExpandReservationParameters = new GdsExpandReservationParameters();
        gdsExpandReservationParameters.setReservationUid(restParams.getReservationUid());
        restParams.getTravellerAncillaryFees().stream().map(this::buildTravellerParams).forEach(gdsExpandReservationParameters.getExpandTravellers()::add);
        return Collections.singletonList(gdsExpandReservationParameters);
    }

    private GdsExpandReservationTraveller buildTravellerParams(RestTravellerAncillaryFees taf) {
        GdsExpandReservationTraveller result = new GdsExpandReservationTraveller();
        result.setTravellerUid(taf.getTravellerUid());
        RestAncillaryFeesHelper.toTypedStream(taf.getAncillaryFees(), RestAncillaryFee.class).filter(RestAncillaryFee::isSelected).map(this::buildAncillaryFeesParams).forEach(result.getAncillaryFees()::add);
        return result;
    }

    private AncillaryFeeReservationParameters buildAncillaryFeesParams(RestAncillaryFee restAncillaryFeeParams) {
        AncillaryFeeReservationParameters result = new AncillaryFeeReservationParameters();
        result.setGdsId(restAncillaryFeeParams.getGdsId());
        result.setQuantity(restAncillaryFeeParams.getQuantity());
        result.setFreeText(restAncillaryFeeParams.getFreeText());
        return result;
    }
}

