/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.CancelBookingAncillaryFeesParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;

public class PrepareRailCancelAncillaryFeesParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        CancelBookingAncillaryFeesParameters parameters = (CancelBookingAncillaryFeesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (parameters.getMcoUids().isEmpty()) {
            throw Xeption.forDeveloper((String)"mco uid is empty", (Object[])new Object[0]);
        }
        ArrayList<RailwayMcoProduct> products = new ArrayList<RailwayMcoProduct>();
        for (String mcoUid : parameters.getMcoUids()) {
            RailwayMcoProduct product = (RailwayMcoProduct)BookingHelper.findProductByUid((String)mcoUid, (BookingFile)reservation.getBookingFile(), RailwayMcoProduct.class);
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find rail mco product by uid {0}", (Object[])new Object[]{mcoUid});
            }
            if (!reservation.getProducts().contains(product)) {
                throw Xeption.forDeveloper((String)"rail mco product with uid {0} is not contained in reservation with uid ", (Object[])new Object[]{mcoUid, reservation.getUid()});
            }
            if (product.getStatus() != ProductStatus.BOOKING) {
                throw Xeption.forDeveloper((String)"air product ({0}) has unsupported status {1}", (Object[])new Object[]{mcoUid, product.getStatus()});
            }
            products.add(product);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, products);
    }
}

