/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeHandBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeLuggageInRailwayRoomParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeePetBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailPriceAncillaryFeesReservationParameters;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.AddBookingAncillaryFeesParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailBaggageInRailwayRoomAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailBaggageInRailwayRoomParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailHandBaggageAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailHandBaggageParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailPetBaggageAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailPetBaggageParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestTravellerAncillaryFees;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.List;

public class PriceRailAncillaryFeesValidationAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) {
        if (e instanceof ValidationException) {
            AddBookingAncillaryFeesParameters restParams = (AddBookingAncillaryFeesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
            List gdsParams = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PRICE_ANCILLARY_FEES_RESERVATIONS_PARAMETERS);
            RailPriceAncillaryFeesReservationParameters gdsReservationParams = (RailPriceAncillaryFeesReservationParameters)gdsParams.get(0);
            this.copyValidationMessages(gdsReservationParams, restParams);
            if (ValidationHelper.isValid((Validatable)restParams)) {
                throw Xeption.forDeveloper((String)this.getFirstValidationMessage(gdsParams), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private String getFirstValidationMessage(List<RailPriceAncillaryFeesReservationParameters> gdsParams) {
        List errors = ValidatableUtil.getValidateStrings(gdsParams, (String)"gdsParams");
        return TextUtil.join((String)"; ", (Iterable)errors);
    }

    private void copyValidationMessages(RailPriceAncillaryFeesReservationParameters gdsParams, AddBookingAncillaryFeesParameters restParams) {
        gdsParams.getProductParams().stream().map(RailExpandProductParameters::getAncillaryFees).flatMap(Collection::stream).forEach(gdsAfParams -> {
            RestRailAncillaryFee restFee = restParams.getTravellerAncillaryFees().stream().map(RestTravellerAncillaryFees::getAncillaryFees).flatMap(Collection::stream).filter(RestRailAncillaryFee.class::isInstance).map(RestRailAncillaryFee.class::cast).filter(af -> MiscUtil.equals((Object)af.getUid(), (Object)gdsAfParams.getAncillaryFee().getUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find ancillary fee by uid", (Object[])new Object[]{gdsAfParams.getAncillaryFee().getUid()}));
            switch (restFee.getMcoCategory()) {
                case HAND_BAGGAGE: {
                    this.copyMessages(((RailAncillaryFeeHandBaggageParameters)gdsAfParams.getBaggageParameters()).getValidationContext(), ((RestRailHandBaggageAncillaryFee)restFee).getInputParams().getValidationContext());
                    break;
                }
                case PET_BAGGAGE: {
                    this.copyMessages(((RailAncillaryFeePetBaggageParameters)gdsAfParams.getBaggageParameters()).getValidationContext(), ((RestRailPetBaggageAncillaryFee)restFee).getInputParams().getValidationContext());
                    break;
                }
                case LUGGAGE_IN_RAILWAY_ROOM: {
                    this.copyMessages(((RailAncillaryFeeLuggageInRailwayRoomParameters)gdsAfParams.getBaggageParameters()).getValidationContext(), ((RestRailBaggageInRailwayRoomAncillaryFee)restFee).getInputParams().getValidationContext());
                }
            }
        });
    }

    private void copyMessages(RailAncillaryFeeHandBaggageParameters.RailAncillaryFeeHandBaggageParametersValidationContext vcFrom, RestRailHandBaggageParameters.RestRailHandBaggageParametersValidationContext vcTo) {
        this.copy(vcFrom.getTypeValidationMessages(), vcTo.getTypeValidationMessages());
        this.copy(vcFrom.getDescriptionValidationMessages(), vcTo.getDescriptionValidationMessages());
    }

    private void copyMessages(RailAncillaryFeePetBaggageParameters.RailAncillaryFeePetBaggageParametersValidationContext vcFrom, RestRailPetBaggageParameters.RestRailPetBaggageParametersValidationContext vcTo) {
        this.copy(vcFrom.getDescriptionValidationMessages(), vcTo.getDescriptionValidationMessages());
    }

    private void copyMessages(RailAncillaryFeeLuggageInRailwayRoomParameters.RailAncillaryFeeLuggageInRailwayRoomParametersValidationContext vcFrom, RestRailBaggageInRailwayRoomParameters.RestRailBaggageInRailwayRoomParametersValidationContext vcTo) {
        this.copy(vcFrom.getDescriptionValidationMessages(), vcTo.getDescriptionValidationMessages());
        this.copy(vcFrom.getPlaceQuantityValidationMessages(), vcTo.getPlaceQuantityValidationMessages());
        this.copy(vcFrom.getCarNumberValidationMessages(), vcTo.getCarNumberValidationMessages());
        this.copy(vcFrom.getDeclaredPriceValidationMessages(), vcTo.getDeclaredPriceValidationMessages());
    }

    private void copy(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        ValidationHelper.copy(from, to);
    }
}

