/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees;

import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.ibecorp.model.helpers.IbecorpPriceStructureHelper;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeHandBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeLuggageInRailwayRoomParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeePetBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAncillaryFeeSegment;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFeeType;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestBaseAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailBaggageInRailwayRoomAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailBaggageInRailwayRoomParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailHandBaggageAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailHandBaggageParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailPetBaggageAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailPetBaggageParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestTravellerAncillaryFees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class RestAncillaryFeesHelper {
    private static final Map<MCOCategory, RestAncillaryFeeType> ancillaryFeeTypesMap = new HashMap<MCOCategory, RestAncillaryFeeType>();
    private static final CollectionUtil.Equator<RestAncillaryFeeSegment, RestAncillaryFeeSegment> restSegmentsEquator;

    public static RestAncillaryFeeType convertToRestAncillaryFeeType(MCOCategory value) {
        return (RestAncillaryFeeType)MiscUtil.guarded((Object)ancillaryFeeTypesMap.get(value), (Object)RestAncillaryFeeType.OTHER);
    }

    private static RestAncillaryFeeType convertAncillaryFeeTypeToRest(AncillaryFeeType value) {
        MCOCategory mcoCategory = GdsDictHelper.convertToMcoCategory((AncillaryFeeType)value);
        return RestAncillaryFeesHelper.convertToRestAncillaryFeeType(mcoCategory);
    }

    static <A extends RestBaseAncillaryFee> Stream<A> toTypedStream(Collection<RestBaseAncillaryFee> collection, Class<A> type) {
        return collection.stream().filter(type::isInstance).map(type::cast);
    }

    public static Map<Integer, RestAncillaryFeeSegment> buildSegmentsMap(List<Leg> legs) {
        HashMap<Integer, RestAncillaryFeeSegment> result = new HashMap<Integer, RestAncillaryFeeSegment>();
        int i = 0;
        for (int legInd = 0; legInd < legs.size(); ++legInd) {
            Leg leg = legs.get(legInd);
            for (int segInd = 0; segInd < leg.getSegments().size(); ++segInd) {
                RestAncillaryFeeSegment item = new RestAncillaryFeeSegment();
                item.setLegIndex(legInd);
                item.setSegmentIndex(segInd);
                result.put(i, item);
                ++i;
            }
        }
        return result;
    }

    public static RestAncillaryFee buildRestAncFee(AncillaryFee fee, PriceComponentsParameters priceParameters, Map<Integer, RestAncillaryFeeSegment> segmentsMap) {
        RestAncillaryFee restAncillaryFee = new RestAncillaryFee();
        restAncillaryFee.setTravelSubject(TravelSubject.AIR);
        restAncillaryFee.setGdsId(fee.getGdsId());
        restAncillaryFee.setType(RestAncillaryFeesHelper.convertAncillaryFeeTypeToRest(fee.getType()));
        if (fee.getDescription() != null) {
            restAncillaryFee.setDescription(fee.getDescription().toString());
            restAncillaryFee.setAncFeeDescriptionRef(fee.getDescription());
        } else {
            restAncillaryFee.setDescription(fee.getGdsDescription());
        }
        restAncillaryFee.setFreeTextAvailability(fee.getFreeTextAvailability());
        Integer maxQuantity = (Integer)MiscUtil.guarded((Object)fee.getMaxQuantityPerPassenger(), (Object)1);
        restAncillaryFee.setMaxQuantityPerPassenger(maxQuantity - MiscUtil.guarded((Integer)fee.getQuantity()));
        restAncillaryFee.setPrice(CommonConverterHelper.convertMoney2Rest(IbecorpPriceStructureHelper.calculatePriceStructure((BaseAncillaryFee)fee).getTotal(), priceParameters.getCurrency()));
        fee.getSegmentNumbers().stream().map(segmentsMap::get).forEach(restAncillaryFee.getSegments()::add);
        return restAncillaryFee;
    }

    public static void updateAncillaryFees(List<RestAncillaryFee> ancillaryFees, Map<String, AncillaryFeeDescription> afDescriptionMap) {
        ancillaryFees.forEach(currentAncillaryFee -> {
            String gdsId = currentAncillaryFee.getGdsId();
            if (TextUtil.isBlank((String)gdsId)) {
                return;
            }
            AncillaryFeeDescription afd = (AncillaryFeeDescription)afDescriptionMap.get(gdsId);
            if (afd == null) {
                return;
            }
            if (afd.getRequiredAncillaryFee() != null) {
                RestAncillaryFee requiredLas = ancillaryFees.stream().filter(las -> MiscUtil.equals((Object)afd.getRequiredAncillaryFee(), (Object)((AncillaryFeeDescription)afDescriptionMap.get(las.getGdsId())).toReference()) && CollectionUtil.sameCollections((Collection)las.getSegments(), (Collection)currentAncillaryFee.getSegments(), restSegmentsEquator)).findFirst().orElse(null);
                currentAncillaryFee.setEnabled(requiredLas != null && requiredLas.isSelected());
                if (requiredLas != null && !requiredLas.isSelected()) {
                    currentAncillaryFee.setSelected(false);
                }
            }
            if (!afd.getExclusiveAncillaryFees().isEmpty()) {
                boolean existsSelectedExclusive = ancillaryFees.stream().filter(las -> las.isSelected() && CollectionUtil.sameCollections((Collection)las.getSegments(), (Collection)currentAncillaryFee.getSegments(), restSegmentsEquator)).anyMatch(las -> afd.getExclusiveAncillaryFees().contains(((AncillaryFeeDescription)afDescriptionMap.get(las.getGdsId())).toReference()));
                currentAncillaryFee.setEnabled(!existsSelectedExclusive);
            }
        });
    }

    static List<RailExpandProductParameters> buildRailExpandProductParameters(List<RestTravellerAncillaryFees> travellerAncillaryFees) {
        ArrayList<RailExpandProductParameters> result = new ArrayList<RailExpandProductParameters>();
        for (RestTravellerAncillaryFees travellerAncillaryFee : travellerAncillaryFees) {
            RailExpandProductParameters productParams = new RailExpandProductParameters();
            productParams.setProductUid(travellerAncillaryFee.getProductUid());
            RestAncillaryFeesHelper.toTypedStream(travellerAncillaryFee.getAncillaryFees(), RestRailAncillaryFee.class).map(restAf -> RestAncillaryFeesHelper.buildAncillaryFeesParams(restAf, travellerAncillaryFee.getProductUid())).forEach(productParams.getAncillaryFees()::add);
            result.add(productParams);
        }
        return result;
    }

    private static RailAncillaryFeeReservationParameters buildAncillaryFeesParams(RestRailAncillaryFee restAncillaryFee, String productUid) {
        RailwayMcoCategory mcoCategory = restAncillaryFee.getMcoCategory();
        if (mcoCategory == null) {
            throw Xeption.forDeveloper((String)"mcoCategory is null", (Object[])new Object[0]);
        }
        RailAncillaryFeeReservationParameters result = new RailAncillaryFeeReservationParameters();
        RailwayAncillaryFee af = new RailwayAncillaryFee();
        af.setProductUid(productUid);
        af.setGdsId(restAncillaryFee.getGdsId());
        af.setMcoCategory(mcoCategory);
        af.setName(restAncillaryFee.getDescription());
        af.setGdsDescription(restAncillaryFee.getTooltip());
        af.setMaxQuantityPerPassenger(Integer.valueOf(restAncillaryFee.getMaxQuantityPerPassenger()));
        af.setQuantity(Integer.valueOf(restAncillaryFee.getQuantity()));
        result.setAncillaryFee(af);
        result.setBaggageParameters(RestAncillaryFeesHelper.buildBaggageParameters(mcoCategory, restAncillaryFee));
        restAncillaryFee.setUid(af.getUid());
        return result;
    }

    private static RailAncillaryFeeBaggageParameters buildBaggageParameters(RailwayMcoCategory mcoCategory, RestRailAncillaryFee restAncillaryFee) {
        switch (mcoCategory) {
            case HAND_BAGGAGE: {
                return RestAncillaryFeesHelper.buildHandBaggage(((RestRailHandBaggageAncillaryFee)restAncillaryFee).getInputParams());
            }
            case PET_BAGGAGE: {
                return RestAncillaryFeesHelper.buildPetBaggage(((RestRailPetBaggageAncillaryFee)restAncillaryFee).getInputParams());
            }
            case LUGGAGE_IN_RAILWAY_ROOM: {
                return RestAncillaryFeesHelper.buildLuggageInRailwayRoom(((RestRailBaggageInRailwayRoomAncillaryFee)restAncillaryFee).getInputParams());
            }
        }
        return null;
    }

    private static RailAncillaryFeeHandBaggageParameters buildHandBaggage(RestRailHandBaggageParameters handBaggage) {
        if (handBaggage == null) {
            throw Xeption.forDeveloper((String)"handBaggage is null for HAND_BAGGAGE", (Object[])new Object[0]);
        }
        RailAncillaryFeeHandBaggageParameters result = new RailAncillaryFeeHandBaggageParameters();
        result.setType(handBaggage.getType());
        result.setDescription(handBaggage.getDescription());
        return result;
    }

    private static RailAncillaryFeePetBaggageParameters buildPetBaggage(RestRailPetBaggageParameters petBaggage) {
        if (petBaggage == null) {
            throw Xeption.forDeveloper((String)"petBaggage is null for PET_BAGGAGE", (Object[])new Object[0]);
        }
        RailAncillaryFeePetBaggageParameters result = new RailAncillaryFeePetBaggageParameters();
        result.setDescription(petBaggage.getDescription());
        return result;
    }

    private static RailAncillaryFeeLuggageInRailwayRoomParameters buildLuggageInRailwayRoom(RestRailBaggageInRailwayRoomParameters luggageInRailwayRoom) {
        if (luggageInRailwayRoom == null) {
            throw Xeption.forDeveloper((String)"luggageInRailwayRoom is null for LUGGAGE_IN_RAILWAY_ROOM", (Object[])new Object[0]);
        }
        RailAncillaryFeeLuggageInRailwayRoomParameters result = new RailAncillaryFeeLuggageInRailwayRoomParameters();
        result.setDescription(luggageInRailwayRoom.getDescription());
        result.setPlaceQuantity(Integer.valueOf(luggageInRailwayRoom.getPlaceQuantity()));
        result.setCarNumber(luggageInRailwayRoom.getCarNumber());
        result.setDeclaredPrice(Integer.valueOf(luggageInRailwayRoom.getDeclaredPrice()));
        return result;
    }

    static {
        ancillaryFeeTypesMap.put(MCOCategory.EXCESS_LUGGAGE, RestAncillaryFeeType.BAGGAGE);
        ancillaryFeeTypesMap.put(MCOCategory.SPECIAL_FOOD, RestAncillaryFeeType.MEALS);
        ancillaryFeeTypesMap.put(MCOCategory.SEAT_RESERVATION, RestAncillaryFeeType.SEAT_RESERVATION);
        restSegmentsEquator = (o1, o2) -> {
            if (o1.getLegIndex() == o2.getLegIndex()) {
                int ta2;
                int ta = o1.getSegmentIndex();
                return ta == (ta2 = o2.getSegmentIndex());
            }
            return false;
        };
    }
}

