/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.json.JSONMarshaller;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.authorization.AuthorizationTemporalObjectData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.AuthTokenParam;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.AuthorizationTempToken;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import org.json.JSONObject;

public class DecodeAuthTempTokenProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String decodedToken;
        AuthTokenParam params = (AuthTokenParam)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (params == null) {
            throw Xeption.forDeveloper((String)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u043e\u043a\u0435\u043d", (Object[])new Object[0]);
        }
        String token = params.getToken();
        try {
            decodedToken = DesUtil.decode((String)token);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u043e\u043a\u0435\u043d", (Object[])new Object[0]);
        }
        JSONObject jsonObject = new JSONObject(decodedToken);
        AuthorizationTempToken authorizationToken = (AuthorizationTempToken)JSONMarshaller.unmarshal((Object)jsonObject, AuthorizationTempToken.class);
        if (authorizationToken == null) {
            throw Xeption.forDeveloper((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430, \u043a\u0442\u043e-\u0442\u043e \u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0441\u0442\u0443\u0447\u0430\u0442\u044c\u0441\u044f \u0432 \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435", (Object[])new Object[0]);
        }
        TemporalObject to = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, authorizationToken.getTempUid());
        if (to == null) {
            throw Xeption.forEndUser((String)"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0436\u0435 \u0431\u044b\u043b\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430 \u0438\u043b\u0438 \u0438\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u0430. \u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043c\u043e\u0436\u043d\u043e \u0432 MOM-\u043a\u043b\u0438\u0435\u043d\u0442\u0435", (Object[])new Object[0]);
        }
        String bookingUid = to.getReferenceUid();
        EntityContainer bfCtr = EntityStorage.get().resolve(new EntityReference(bookingUid, BookingFile.class, null));
        AuthorizationTemporalObjectData data = new AuthorizationTemporalObjectData();
        XUtil.fromBytes((byte[])to.getData(), (XSerializable)data);
        ctx.putObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER, (Object)data.getPerson());
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bfCtr);
        Reservation reservation = (Reservation)CollectionUtil.find((Iterable)((BookingFile)bfCtr.getEntity()).getReservations(), (String)data.getReservationUid());
        BaseProduct product = (BaseProduct)CollectionUtil.find((Iterable)reservation.getProducts(), (String)data.getProductUid());
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, Collections.singletonList(product));
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS, Collections.singletonList(reservation));
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_AUTHORIZATION_APPROVED, (Object)authorizationToken.isApprove());
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_AUTHORIZATION_TEMP_OBJECT, (Object)to);
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_STEP_UID, (Object)data.getStepUid());
    }
}

