/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.stream.Collectors;

public class PrepareAuthorizationParameterProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference currentUser = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        TravelPolicyAuthorizationStatus authorizationStatus = TravelPolicyAuthorizationHelper.getAuthorizationStatus((Reservation)reservation);
        if (authorizationStatus != TravelPolicyAuthorizationStatus.WAIT) {
            throw Xeption.forEndUser((String)"AUTHORIZATION_RESERVATION_STATUS_CHANGED", (Object[])new Object[]{authorizationStatus});
        }
        List products = reservation.getProducts().stream().filter(product -> TravelPolicyAuthorizationHelper.isProductWaitingForAgent((BaseProduct)product, (EntityReference)currentUser)).collect(Collectors.toList());
        if (products.isEmpty()) {
            throw Xeption.forEndUser((String)"NO_PRODUCTS_FOR_AUTHORIZATION", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER, (Object)currentUser);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, products);
    }
}

