/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.checkBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BCheckBookingResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BPaymentInfo;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BookingInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.PaymentInfoStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class B2BCheckBookingResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer agency = EntityStorage.get().resolve(salesContext.getAgency());
        EntityContainer bookingFileEntityContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        EntityContainer bookingFileEntityContainerOld = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_COPY);
        BookingFile bookingFile = (BookingFile)bookingFileEntityContainer.getEntity();
        B2BCheckBookingResult result = new B2BCheckBookingResult();
        BookingInfo bookingInfo = BookingConverterHelper.convertBookingInfo2rest(null, this.getMessage((EntityContainer<Organization>)agency, bookingFile), bookingFileEntityContainer.getUid());
        bookingInfo.setNeedReload(!MiscUtil.equals((Object)bookingFileEntityContainer.getRevision(), (Object)bookingFileEntityContainerOld.getRevision()));
        result.setBookingInfo(bookingInfo);
        PaymentInfoStatus paymentInfoStatus = (PaymentInfoStatus)ctx.getObject((Enum)IBusIbecorpContextKeys.PAYMENT_STATUS);
        B2BPaymentInfo paymentInfo = new B2BPaymentInfo();
        result.setPaymentInfo(paymentInfo);
        if (paymentInfoStatus != null) {
            paymentInfo.setStatus(paymentInfoStatus);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected String getMessage(EntityContainer<Organization> agency, BookingFile bookingFile) {
        if (bookingFile.getReservations().stream().allMatch(r -> CommonIbecorpHelper.getReservationStatus((Reservation)r) == ReservationStatus.ISSUED)) {
            return String.format("Booking [%s] already issued. Contacts: %s", bookingFile.toString(), CommonHelper.buildAllPhoneNumbersByType(((Organization)agency.getEntity()).getCommunications(), CommunicationType.AGENCY));
        }
        if (bookingFile.getReservations().stream().anyMatch(r -> CommonIbecorpHelper.getReservationStatus((Reservation)r) == ReservationStatus.ERROR)) {
            return String.format("Booking [%s] has errors. Contacts: %s", bookingFile.toString(), CommonHelper.buildAllPhoneNumbersByType(((Organization)agency.getEntity()).getCommunications(), CommunicationType.AGENCY));
        }
        if (bookingFile.getReservations().stream().allMatch(r -> CommonIbecorpHelper.getReservationStatus((Reservation)r) == ReservationStatus.CANCELED)) {
            return String.format("Booking [%s] was cancelled. Contacts: %s", bookingFile.toString(), CommonHelper.buildAllPhoneNumbersByType(((Organization)agency.getEntity()).getCommunications(), CommunicationType.AGENCY));
        }
        return null;
    }
}

