/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.checkBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BGetPaymentTypesResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BPaymentInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SabreCard;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SabrePaymentType;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.PaymentTypeInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class B2BGetPaymentTypesBuildResultProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigDecimal totalPrice;
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        B2BGetPaymentTypesResult result = new B2BGetPaymentTypesResult();
        B2BPaymentInfo paymentInfo = new B2BPaymentInfo();
        result.setPaymentInfo(paymentInfo);
        PriceComponentsParameters parameters = this.getPriceConverterParameters(ctx);
        String currency = parameters.getCurrency();
        BigDecimal sabreHotelsTotal = null;
        BigDecimal fee = null;
        boolean hasOthers = false;
        List sabreHotelsPassengers = null;
        for (Reservation reservation : reservations) {
            ReservationStatus reservationStatus = CommonIbecorpHelper.getReservationStatus((Reservation)reservation);
            if (reservationStatus != ReservationStatus.BOOKING && reservationStatus != ReservationStatus.INTENTION) continue;
            if (reservation.getProducts().stream().noneMatch(p -> p instanceof HotelProduct && ((HotelProduct)p).getProvider() == HotelProvider.SABRE)) {
                hasOthers = true;
                break;
            }
            List rp = reservation.getProducts().stream().filter(p -> ((HotelProduct)p).getNextProduct() == null).flatMap(p -> ((HotelProduct)p).getTravellers().stream()).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
            if (null == sabreHotelsPassengers) {
                sabreHotelsPassengers = rp;
            } else {
                sabreHotelsPassengers.retainAll(rp);
            }
            BigDecimal f = reservation.getProducts().stream().map(p -> BookingHelper.calculateFee((BaseProduct)p, (ContractType)ContractType.CLIENT)).reduce(BigDecimal.ZERO, BigDecimal::add);
            fee = fee != null ? fee.add(f) : f;
            totalPrice = ReservationPriceComponents.builder(reservation, parameters).build().getTotal().subtract(f);
            if (null == sabreHotelsTotal) {
                sabreHotelsTotal = totalPrice;
                continue;
            }
            sabreHotelsTotal = sabreHotelsTotal.add(totalPrice);
        }
        if (sabreHotelsTotal != null && !hasOthers) {
            SabrePaymentType sabrePaymentType = new SabrePaymentType();
            paymentInfo.setSabrePaymentType(sabrePaymentType);
            sabrePaymentType.setPrice(CommonConverterHelper.convertMoney2Rest(sabreHotelsTotal, currency));
            Stream.concat(sabreHotelsPassengers.stream().map(p -> EntityStorage.get().resolve(p)).filter(Objects::nonNull).flatMap(p -> ((Person)p.getEntity()).getCards().stream()), ((Organization)EntityStorage.get().resolve(((BookingFile)bookingFileCtr.getEntity()).getCustomerProfile()).getEntity()).getCards().stream()).forEach(c -> {
                SabreCard sc = new SabreCard();
                sc.setUid(c.getUid());
                sc.setCardHolder(c.getNameOnCard());
                sc.setCardNumber(c.getNumber());
                sabrePaymentType.getCards().add(sc);
            });
        }
        if ((null == sabreHotelsTotal || BigDecimal.ZERO.compareTo(fee) != 0) && reservations.stream().map(CommonIbecorpHelper::getReservationStatus).allMatch(s -> ReservationStatus.BOOKING == s || ReservationStatus.INTENTION == s)) {
            PaymentInitiationParameters paymentInitiationParameters = BookingPaymentHelper.createPaymentInitiationParameters(BookingPaymentHelper.getComebackURL(ctx), (EntityContainer<BookingFile>)bookingFileCtr, reservations, salesContext, ContractType.CLIENT);
            Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> paymentTypesMap = BookingPaymentHelper.getPaymentTypesMap(paymentInitiationParameters, (EntityContainer<BookingFile>)bookingFileCtr, reservations, ContractType.CLIENT);
            HashSet<CardVendor> splitCardsSupportedVendors = new HashSet<CardVendor>();
            HashSet<CardVendor> supportedCardVendors = new HashSet<CardVendor>(BookingPaymentHelper.getSupportedCardVendors());
            Collection<AirlineCard> acceptedCards = BookingPaymentHelper.getAcceptedCards(reservations);
            if (acceptedCards != null && !acceptedCards.isEmpty()) {
                splitCardsSupportedVendors.addAll(BookingPaymentHelper.getSabreSupportedCardVendors(acceptedCards));
                supportedCardVendors.removeAll(splitCardsSupportedVendors);
            }
            totalPrice = PaymentHelper.getPaymentPrice((Collection)reservations, (ContractType)ContractType.CLIENT, null, null);
            for (Map.Entry<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> ptEntry : paymentTypesMap.entrySet()) {
                Map<PaymentType, PaymentTypeInfo> paymentInfoTypesMap;
                PaymentType paymentType = ptEntry.getKey();
                if (paymentType == null || (paymentInfoTypesMap = this.getPaymentInfoTypesMap(paymentType, paymentInfo, siteType)) == null) continue;
                PaymentTypeInfo paymentTypeInfo = com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingConverterHelper.convertPaymentTypeInfo2Rest(ptEntry, totalPrice, currency, splitCardsSupportedVendors, supportedCardVendors);
                paymentInfoTypesMap.put(paymentType, paymentTypeInfo);
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }

    private Map<PaymentType, PaymentTypeInfo> getPaymentInfoTypesMap(PaymentType paymentType, B2BPaymentInfo paymentInfo, SMSiteType siteType) {
        if (paymentType == null) {
            return null;
        }
        if (BookingConverterHelper.isCreditCardPaymentType(paymentType)) {
            return paymentInfo.getCreditCardsPaymentTypes();
        }
        boolean isB2c = siteType == SMSiteType.B2C;
        switch (paymentType) {
            case INVOICE: {
                return paymentInfo.getInvoicePaymentTypes();
            }
            case CASH: {
                return isB2c ? paymentInfo.getCashOfficePaymentTypes() : paymentInfo.getCashPaymentTypes();
            }
            case CASH_DELIVERY: 
            case CASH_PLATRON: {
                return isB2c ? paymentInfo.getCashPaymentTypes() : null;
            }
        }
        return paymentInfo.getInvoicePaymentTypes();
    }
}

