/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.correspondence;

import com.gridnine.xtrip.common.ibecorp.exception.RankedXeption;
import com.gridnine.xtrip.common.ibecorp.exception.XeptionSeverity;
import com.gridnine.xtrip.common.ibecorp.model.IBusCorrespondenceContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueSubject;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.Messages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.Attachment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class CorrespondenceCreateProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseIssue issue;
        EntityReference bookingFileRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusCorrespondenceContextKeys.BOOKING_FILE_REFERENCE);
        String issueUid = (String)ctx.getObject((Enum)IBusCorrespondenceContextKeys.ISSUE_UID);
        Class issueClass = (Class)ctx.getMandatoryObject((Enum)IBusCorrespondenceContextKeys.ISSUE_CLASS);
        String title = (String)ctx.getObject((Enum)IBusCorrespondenceContextKeys.ISSUE_TITLE);
        String content = (String)ctx.getMandatoryObject((Enum)IBusCorrespondenceContextKeys.ISSUE_CONTENT);
        List attachments = (List)ctx.getObject((Enum)IBusCorrespondenceContextKeys.ISSUE_ATTACHMENTS);
        Communication hotelEmail = (Communication)ctx.getObject((Enum)IBusCorrespondenceContextKeys.HOTEL_EMAIL);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (TextUtil.isBlank((String)bookingFileRef.getCaption())) {
            EntityStorage.get().actualize(bookingFileRef, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true).processedUncachedEntity(true));
        }
        EntityReference authorizedUserRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        EntityContainer<? extends BaseIssue> issueCtr = CorrespondenceCreateProcessor.loadIssue(issueUid, (EntityReference<BookingFile>)bookingFileRef);
        if (issueCtr == null) {
            EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
            issueCtr = BookingConverterHelper.createBookingIssue((EntityContainer<BookingFile>)bookingFileCtr, (EntityReference<Person>)authorizedUserRef, issueClass);
            issue = (BaseIssue)issueCtr.getEntity();
            if (reservation != null) {
                issue.setReservation(new NestedEntityReference(bookingFileCtr, (BaseEntity)reservation));
            }
            if (TextUtil.nonBlank((String)title)) {
                issue.setTitle(title);
            } else {
                issue.setTitle(L10n.replace((String)"\u0412\u043e\u043f\u0440\u043e\u0441 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 \u2116{0}", (Object[])new Object[]{((BookingFile)bookingFileCtr.getEntity()).toString()}));
            }
            String description = null;
            issue.setDescription(description);
            if (!TextUtil.isBlank(description)) {
                issue.setUnreadPosts(issue.getUnreadPosts() - 1);
            }
            VersionInfo versionInfo = issueCtr.getVersionInfo();
            versionInfo.setDataSource(ctx.getRouteId());
            versionInfo.setVersionNotes(((Object)((Object)this)).getClass().getName());
        }
        EntityReference issueRef = issueCtr.toReference();
        issue = (BaseIssue)issueCtr.getEntity();
        Post post = new Post();
        post.setAuthor(authorizedUserRef);
        post.setDateCreated(new Date());
        post.setClient(!(issue instanceof RequestForHotelBookingIssue));
        post.setHotelEmail(hotelEmail);
        if (TextUtil.nonBlank((String)content)) {
            post.setContent(content);
            issue.getEvents().add(NotificationEvent.COMMENT_ADDED);
        }
        if (attachments != null && !attachments.isEmpty()) {
            for (Attachment attachment : attachments) {
                if (TextUtil.isBlank((String)attachment.getUid())) continue;
                String name = attachment.getName();
                EntityContainer docCtr = new EntityContainer(Document.class);
                Document doc = (Document)docCtr.getEntity();
                byte[] docContent = Base64.decode((String)attachment.getContent());
                doc.setContent(docContent);
                doc.setCheckSum(MiscUtil.getCheckSum((byte[])docContent));
                doc.setContentType(attachment.getType() == null ? HttpHelper.detectContentType((String)name) : attachment.getType());
                doc.setCreated(new Date());
                doc.setDescription(name);
                doc.setName(name);
                doc.setNavigationKey(post.getUid());
                doc.setOwner(issueRef);
                doc.setTitle(name);
                doc.setType(DocumentType.ISSUE_ATTACHMENT);
                post.getAttachments().add(docCtr.toReference());
                EntityStorage.get().save(docCtr, true);
            }
            issue.getEvents().add(NotificationEvent.ATTACHMENT_ADDED);
        }
        issue.getPosts().add(post);
        issue.setUpdateDate(new Date());
        if (!(issue instanceof RequestForHotelBookingIssue)) {
            issue.setUnreadPosts(issue.getUnreadPosts() + 1);
        }
        if (issue.getStatus() == IssueStatus.CLOSED) {
            issue.setStatus(IssueStatus.NEW);
        }
        EntityStorage.get().save(issueCtr, true);
    }

    private static EntityContainer<? extends BaseIssue> loadIssue(String issueUid, EntityReference<BookingFile> bookingFileRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.booking.name(), bookingFileRef));
        query.getPreferredProperties().add(IssueIndex.Property.number.name());
        query.getPreferredProperties().add(IssueIndex.Property.subject.name());
        List data = EntityStorage.get().search(IssueIndex.class, query).getData();
        if (data.isEmpty()) {
            return null;
        }
        List questionIndexes = data.stream().filter(ind -> ind.getSubject() == IssueSubject.QUESTION).collect(Collectors.toList());
        if (questionIndexes.isEmpty()) {
            return null;
        }
        if (TextUtil.isBlank((String)issueUid)) {
            throw RankedXeption.forEndUser((XeptionSeverity)XeptionSeverity.WARNING, (String)Messages.getCorrespondenceIsAlreadyCreated().getText(), (Object[])new Object[0]);
        }
        IssueIndex issueIndex = data.stream().filter(ind -> issueUid.equals(ind.getSource().getUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"invalid issueUid", (Object[])new Object[0]));
        EntityReference issueRef = issueIndex.getSource();
        if (issueIndex.getSubject() != IssueSubject.QUESTION) {
            issueRef = ((IssueIndex)questionIndexes.get(0)).getSource();
        }
        return EntityStorage.get().resolve(issueRef);
    }
}

