/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.correspondence;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.DownloadAttachmentParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class CorrespondenceDownloadAttachmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DownloadAttachmentParameters parameters = (DownloadAttachmentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String attachmentUid = parameters.getAttachment();
        if (TextUtil.isBlank((String)attachmentUid)) {
            parameters.getValidationContext().getAttachmentValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            throw new ValidationException();
        }
        EntityReference bookingFileRef = parameters.getBooking();
        if (null == bookingFileRef) {
            parameters.getValidationContext().getBookingValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            throw new ValidationException();
        }
        EntityContainer docCtr = EntityStorage.get().load(Document.class, attachmentUid);
        if (null == docCtr) {
            parameters.getValidationContext().getAttachmentValidationMessages().add(StandardValidationMessages.getWrongValue());
            throw new ValidationException();
        }
        Document doc = (Document)docCtr.getEntity();
        EntityContainer issueCtr = EntityStorage.get().resolve(doc.getOwner());
        if (null == issueCtr || !bookingFileRef.equals((Object)((BaseIssue)issueCtr.getEntity()).getBooking())) {
            parameters.getValidationContext().getAttachmentValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            throw new ValidationException();
        }
        DownloadableData downloadableData = new DownloadableData();
        downloadableData.setFileName(doc.getName());
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(doc.getContentType());
        binaryData.setData(doc.getContent());
        downloadableData.setContent(binaryData);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)downloadableData);
    }
}

