/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.correspondence;

import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.BaseIssueHandler;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.IssueHandlersRegistry;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.Attachment;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.InfoParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.InfoResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.Issue;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.Post;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

public class CorrespondenceInfoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        InfoParameters parameters = (InfoParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference bookingFileRef = parameters.getBooking();
        HashMap<EntityReference<Person>, EntityReference<Person>> updatedPersonRefs = new HashMap<EntityReference<Person>, EntityReference<Person>>();
        InfoResult result = new InfoResult();
        if (bookingFileRef != null) {
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)IssueIndex.Property.booking.name(), (Object)bookingFileRef));
            if (parameters.getIssue() != null) {
                searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)parameters.getIssue()));
            }
            SearchResult searchResult = EntityStorage.get().search(IssueIndex.class, searchQuery);
            for (IssueIndex index : searchResult.getData()) {
                EntityContainer issueCtr = EntityStorage.get().resolve(index.getSource());
                if (null == issueCtr) continue;
                BaseIssueHandler handler = IssueHandlersRegistry.get().getHandler(issueCtr.getEntityType());
                BaseIssue baseIssue = (BaseIssue)issueCtr.getEntity();
                Issue issue = new Issue();
                issue.setUid(issueCtr.getUid());
                issue.setSubject(handler.getSubject(baseIssue));
                issue.setTitle(baseIssue.getTitle());
                issue.setDescription(TextUtil.nonBlank((String)baseIssue.getDescription()) && !CollectionUtil.contains((Collection)baseIssue.getPosts(), (Object)baseIssue.getDescription(), (o1, o2) -> Objects.equals(o2, o1.getContent())) ? baseIssue.getDescription() : null);
                issue.setCreateDate(new DateTime((Object)baseIssue.getCreateDate()));
                issue.setAuthor(this.updatePersonRef((EntityReference<Person>)baseIssue.getAuthor(), updatedPersonRefs));
                issue.setStatus(baseIssue.getStatus());
                for (com.gridnine.xtrip.common.model.ibecorp.correspondence.Post p : baseIssue.getPosts()) {
                    Post post = new Post();
                    post.setCreateDate(new DateTime((Object)p.getDateCreated()));
                    if (p.getAuthor() != null) {
                        post.setAuthor(this.updatePersonRef((EntityReference<Person>)p.getAuthor(), updatedPersonRefs));
                    } else if (p.getHotelEmail() != null) {
                        post.setAuthor(new EntityReference(null, Person.class, p.getHotelEmail().getSense()));
                    }
                    post.setContent(p.getContent());
                    for (EntityReference docRef : p.getAttachments()) {
                        EntityContainer docCtr = EntityStorage.get().resolve(docRef);
                        Attachment attachment = new Attachment();
                        attachment.setUid(docCtr.getUid());
                        Document doc = (Document)docCtr.getEntity();
                        attachment.setCreateDate(new DateTime((Object)doc.getCreated()));
                        attachment.setName(doc.getName());
                        byte[] content = doc.getContent();
                        attachment.setSize(content == null ? 0 : content.length);
                        attachment.setType(doc.getContentType());
                        post.getAttachments().add(attachment);
                    }
                    issue.getPosts().add(post);
                }
                result.getIssues().add(issue);
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private EntityReference<Person> updatePersonRef(EntityReference<Person> personRef, Map<EntityReference<Person>, EntityReference<Person>> updatedPersonRefs) {
        if (personRef == null) {
            return null;
        }
        if (updatedPersonRefs.containsKey(personRef)) {
            return updatedPersonRefs.get(personRef);
        }
        EntityContainer personCtr = EntityStorage.get().resolve(personRef);
        String caption = personCtr == null ? null : PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)personCtr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)true);
        EntityReference updatedRef = new EntityReference(null, Person.class, caption);
        updatedPersonRefs.put(personRef, (EntityReference<Person>)updatedRef);
        return updatedRef;
    }
}

