/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.correspondence;

import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.correspondence.CreateIssueParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class CreateIssueParametersValidationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IssueIndex index;
        CreateIssueParameters parameters = (CreateIssueParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference bookingFileRef = parameters.getBooking();
        if (null == bookingFileRef) {
            parameters.getValidationContext().getBookingValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            throw new ValidationException();
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
        if (null == bookingFileCtr) {
            parameters.getValidationContext().getBookingValidationMessages().add(StandardValidationMessages.getWrongValue());
            throw new ValidationException();
        }
        String issueUid = parameters.getIssue();
        if (TextUtil.nonBlank((String)issueUid) && (null == (index = CreateIssueParametersValidationProcessor.findIssueIndex(issueUid)) || !bookingFileRef.equals((Object)index.getBooking()))) {
            parameters.getValidationContext().getIssueValidationMessages().add(StandardValidationMessages.getWrongValue());
            throw new ValidationException();
        }
    }

    private static IssueIndex findIssueIndex(String issueUid) {
        if (TextUtil.isBlank((String)issueUid)) {
            return null;
        }
        return (IssueIndex)SearchHelper.uniqueEntity(IssueIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)"containerUid", (Object)issueUid)});
    }
}

