/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsIntentionCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.FakeHotelProductHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildHotelFakeReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        HotelsIntentionCreationParameters params = (HotelsIntentionCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Map travellersCostCodes = (Map)ctx.getObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)this.buildReservation(params, salesContext, travellersCostCodes));
    }

    private Reservation buildReservation(HotelsIntentionCreationParameters params, SalesContext salesContext, Map<Traveller, List<CostCode>> travellersCostCodes) {
        Reservation reservation = new Reservation();
        Date now = new Date();
        params.getOffers().stream().map(HotelOffer::getGdsAccount).filter(Objects::nonNull).findFirst().ifPresent(gdsAccountRef -> reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountRef));
        reservation.setPricingDate(now);
        reservation.setResDate(now);
        reservation.setBookingAgent(salesContext.getAgent());
        reservation.setSalesPoint(salesContext.getSalesPoint());
        reservation.setSubagency(salesContext.getSubagency());
        reservation.setType(ReservationType.IBE);
        if (reservation.getSubagency() == null) {
            if (salesContext.getAgency() != null) {
                reservation.setSubagency(salesContext.getAgency());
            } else {
                try {
                    EntityContainer spCtr = EntityStorage.get().resolve(salesContext.getSalesPoint());
                    if (spCtr != null) {
                        reservation.setSubagency(((SalesPoint)spCtr.getEntity()).getAgency());
                    }
                }
                catch (Exception e) {
                    this.log.error("failed loading agency", (Throwable)e);
                }
            }
        }
        for (HotelOffer offer : params.getOffers()) {
            FakeHotelProductHelper.buildFakeHotelProduct((HotelOffer)offer, (Reservation)reservation, (HotelCard)params.getHotelCard(), (SalesContext)salesContext, travellersCostCodes);
        }
        HotelsReservationHelper.updateTimeLimit((Reservation)reservation);
        return reservation;
    }
}

