/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ereg;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailEregProductProxy;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class ChangeEregPreviewProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailProxy railProxy = (RailProxy)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        List products = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCTS);
        for (RailwayProduct product : products) {
            if (this.isContinue((BaseProduct)product)) continue;
            RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
            for (Traveller traveller : product.getPassengers()) {
                RailEregProductProxy productProxy = RzdHelper.getCommonRailProductProxy(product, traveller, RailEregProductProxy.class);
                productProxy.setOperation(this.getOperation(!segment.isHasEReg()));
                productProxy.setTicketNumber(product.getSystemNumber());
                railProxy.getProducts().add(productProxy);
            }
        }
    }

    private String getOperation(boolean b) {
        return b ? L10nResourcesManager.getStr((String)"IBECORP_RAIL_EREG_TEMPLATE_ENABLE_REGISTRATION", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"IBECORP_RAIL_EREG_TEMPLATE_DISABLE_REGISTRATION", (Object[])new Object[0]);
    }

    private boolean isContinue(BaseProduct baseProduct) {
        if (baseProduct instanceof RailwayProduct) {
            return ((RailwayProduct)baseProduct).getStatus() != ProductStatus.SELL;
        }
        return true;
    }
}

