/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ereg;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailEregProductProxy;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RailProxy;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.model.cabinet.RailProductProxy;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class RailEregDocumentContentGenerator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailProxy source = (RailProxy)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_PROXY);
        List contents = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusIbecorpRailContextKeys.DOCUMENT_CONTENTS, () -> new ArrayList());
        byte[] content = this.generateContent(source);
        contents.add(Base64.encode((byte[])content));
    }

    private byte[] generateContent(RailProxy source) throws Exception {
        JasperReport report = JasperUtil.getReport((URL)((Object)((Object)this)).getClass().getResource("resource/railEregTemplate.jrxml"));
        Map<String, Object> params = RailEregDocumentContentGenerator.getReportParameters(source);
        JasperPrint pdfPrint = JasperFillManager.fillReport((JasperReport)report, params, (JRDataSource)RailEregDocumentContentGenerator.getDataSource(source));
        return JasperExportManager.exportReportToPdf((JasperPrint)pdfPrint);
    }

    private static Map<String, Object> getReportParameters(RailProxy source) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("orderNumber", source.getOrderNumber());
        parameters.put("ticketNumber", source.getProductNumber());
        parameters.put("inquiryDate", new Date());
        parameters.put("transactionNumber", source.getTransactionNumber());
        parameters.put("orderDate", source.getOrderDate());
        parameters.put("trainNumber", source.getTrainNumber());
        parameters.put("route", source.getTrainRoute());
        parameters.put("departureDate", source.getDepartureDate());
        parameters.put("arrivalDate", source.getArrivalDate());
        parameters.put("carriageInfo", source.getCarriageInfo());
        parameters.put("seatsInfo", source.getSeatInfo());
        parameters.put("additionalInfo", source.getAdditionalInfo());
        return parameters;
    }

    private static JRDataSource getDataSource(RailProxy source) {
        return new JRMapCollectionDataSource(RailEregDocumentContentGenerator.getTicketsList(source));
    }

    private static List<Map<String, ?>> getTicketsList(RailProxy source) {
        ArrayList dataList = new ArrayList();
        ArrayList ticketsList = new ArrayList();
        int number = 1;
        for (RailProductProxy proxy : source.getProducts()) {
            RailEregProductProxy product = (RailEregProductProxy)proxy;
            HashMap<String, Object> ticketDescription = new HashMap<String, Object>();
            ticketDescription.put("number", number);
            ticketDescription.put("tariff", product.getPassengerType());
            ticketDescription.put("document", product.getPassengerDoc());
            ticketDescription.put("passenger", product.getPassengerFio());
            ticketDescription.put("operation", product.getOperation());
            ticketDescription.put("ticketNumber", product.getTicketNumber());
            ++number;
            ticketsList.add(ticketDescription);
        }
        HashMap ticketsListDescription = new HashMap();
        ticketsListDescription.put("tickets", ticketsList);
        dataList.add(ticketsListDescription);
        return dataList;
    }
}

