/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ExchangeSearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Collection;
import java.util.Date;

public class ExchangeParamsValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ExchangeSearchFlightsParameters params = (ExchangeSearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservationUids = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        Collection reservations = PaymentHelper.getReservations((EntityContainer)bfCtr, (Collection)reservationUids);
        Reservation reservationWithInvalidStatus = reservations.stream().filter(res -> res.getStatus() == ReservationStatus.ERROR).findFirst().orElse(null);
        params.getRoute().forEach(route -> AviaValidationHelper.validateRoute((BaseRoute)route, minimumDate));
        if (!ValidationHelper.isValid((Validatable)params)) {
            throw new ValidationException();
        }
        if (reservationWithInvalidStatus != null) {
            throw Xeption.forEndUser((String)"REFEX_BOOKING_FILE_VALIDATOR_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_BECAUSE_THE_STATUS_OF_THE_ORDER_IS_EQUAL_TO_X", (Object[])new Object[]{reservationWithInvalidStatus.getStatus().toString()});
        }
    }
}

