/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.exchange;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.ExchangeParameters;
import com.gridnine.xtrip.common.gds.model.ExchangeRouteSegment;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ExchangeFlightLeg;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ExchangeSearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PrepareExchangeParamsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ExchangeSearchFlightsParameters params = (ExchangeSearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        Collection reservationUids = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        if (products.isEmpty()) {
            throw Xeption.forDeveloper((String)"products are empty", (Object[])new Object[0]);
        }
        if (reservationUids.size() != 1) {
            throw Xeption.forDeveloper((String)"supported products from only one reservation", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.EXCHANGE_PARAMS, (Object)this.buildExchangeParams(params, products));
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)this.buildFlightSearchParams(params, products));
    }

    private ExchangeParameters buildExchangeParams(ExchangeSearchFlightsParameters params, List<BaseProduct> products) {
        ExchangeParameters result = new ExchangeParameters();
        result.getProductUids().addAll(CollectionUtil.getUids(products));
        params.getRoute().stream().map(this::convertFlightLeg).forEach(result.getRoute()::add);
        return result;
    }

    private ExchangeRouteSegment convertFlightLeg(ExchangeFlightLeg restLeg) {
        ExchangeRouteSegment result = new ExchangeRouteSegment();
        AviaConverterHelper.populateSegment(null, (BaseRoute)restLeg, (RouteSegment)result);
        result.setChanged(restLeg.isChanged());
        result.getSegmentNumbers().addAll(restLeg.getSegmentNumbers());
        return result;
    }

    private FlightSearchParameters buildFlightSearchParams(ExchangeSearchFlightsParameters params, List<BaseProduct> products) {
        FlightSearchParameters result = new FlightSearchParameters();
        params.getRoute().stream().map(restLeg -> {
            RouteSegment seg = new RouteSegment();
            AviaConverterHelper.populateSegment(null, (BaseRoute)restLeg, seg);
            return seg;
        }).forEach(result.getRoute()::add);
        Map passengerTypesMap = products.stream().map(Product.class::cast).map(Product::getPassengerType).collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, e -> 1, Integer::sum)));
        result.getSeats().addAll(GDSHelper.getSeatPreferences(passengerTypesMap));
        return result;
    }
}

