/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.ibecorp.rules.BookingContactActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingExternalSystemsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.BookingTravellersEditingActionsSet;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.b2b.BookingFormSettingsToken;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BSelectedPassengerConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestKeyContactsConfig;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestReasonCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestReasonCodeConfig;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestBookingPerson;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseBookingFormSettingsProcessor
extends BaseProcessor {
    private static final Set<TravelSubject> USE_TRAVELLER_NAME_FROM_DOCUMENTS_TRAVEL_SUBJECTS = EnumSet.of(TravelSubject.AIR, TravelSubject.RAILWAY);

    protected boolean isContactAutocompleteAvailable(SMSiteType siteType, EntityContainer<Organization> clientCtr) {
        return siteType == SMSiteType.B2B && !ProfileHelper.isRetailProfile(clientCtr);
    }

    protected void setSearchDuplicatesMessageData(BookingFormSettings result, AckMessage searchDuplicatesMessage) throws Exception {
        result.setSearchDuplicatesMessage(CommonConverterHelper.convertToRestAckMessage(searchDuplicatesMessage));
        BookingFormSettingsToken token = new BookingFormSettingsToken();
        token.setSearchDuplicatesMessage(searchDuplicatesMessage);
        result.setBookingFormSettingsToken(B2BRestHelper.encodeToken((XSSerializable)token));
    }

    public List<RestBookingPerson> getPassengers(BookingFile bookingFile, Collection<EntityReference<Person>> persons, Map<EntityReference<Person>, DictionaryReference<PassengerType>> passengerTypes, EntityReference<Organization> orgRef) {
        return persons.stream().map(passenger -> {
            EntityContainer personCtr = EntityStorage.get().resolve(passenger);
            if (personCtr != null) {
                RestBookingPerson restPerson = B2BSelectedPassengerConverterHelper.convertPerson2Rest((EntityContainer<Person>)personCtr, bookingFile, orgRef);
                restPerson.setUid(personCtr.getUid());
                restPerson.setPassengerType((DictionaryReference)passengerTypes.get(passenger));
                return restPerson;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static void setKeyContact(BookingFormSettings result, EntityContainer<Organization> clientCtr, TravelPolicyImpositionResult tpImpositionResult) {
        RestKeyContactsConfig keyContacts = BaseBookingFormSettingsProcessor.getKeyContacts(clientCtr, tpImpositionResult);
        if (keyContacts != null && keyContacts.getValues().isEmpty()) {
            throw Xeption.forEndUser((String)"VALIDATION_EMPTY_KEY_CONTACTS", (Object[])new Object[0]);
        }
        result.setKeyContact(keyContacts);
    }

    private static RestKeyContactsConfig getKeyContacts(EntityContainer<Organization> clientCtr, TravelPolicyImpositionResult travelPolicyImpositionResult) {
        if (!CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult)) {
            return null;
        }
        if (clientCtr == null) {
            return null;
        }
        RestKeyContactsConfig config = new RestKeyContactsConfig();
        for (ProfileKeyContactPerson contact : ((Organization)clientCtr.getEntity()).getKeyContacts()) {
            if (contact.getPerson() == null || !contact.isAuthorizer()) continue;
            config.getValues().add(contact.getPerson());
        }
        return config;
    }

    protected static RestReasonCodeConfig getReasonCode(EntityContainer<Organization> clientCtr, TravelPolicyImpositionResult travelPolicyImpositionResult, ReasonCodeType type) {
        if (travelPolicyImpositionResult != null && !travelPolicyImpositionResult.isReasonCodeRequired()) {
            return null;
        }
        RestReasonCodeConfig config = new RestReasonCodeConfig();
        if (null == clientCtr) {
            return config;
        }
        List reasonCodes = type == ReasonCodeType.REASON_CODE_AIR ? ((Organization)clientCtr.getEntity()).getReasonCodes().stream().filter(r -> r.getType() == type).filter(r -> r.getComparisonType() == ReasonCodeComparisonType.AFS).collect(Collectors.toList()) : ((Organization)clientCtr.getEntity()).getReasonCodes().stream().filter(r -> r.getType() == type).collect(Collectors.toList());
        if (reasonCodes.isEmpty()) {
            return config;
        }
        for (ReasonCode reasonCode : reasonCodes) {
            RestReasonCode value = new RestReasonCode();
            value.setUid(reasonCode.getName());
            String caption = reasonCode.getRemarks().toString();
            if (TextUtil.isBlank((String)caption)) {
                caption = reasonCode.getName();
            }
            value.setCaption(caption);
            config.getValues().add(value);
        }
        return config;
    }

    protected static void setTravellerData(BookingFormSettings result, SalesContext salesContext, TravelSubject travelSubject) throws Exception {
        BookingTravellersEditingActionsSet bookingTravellersActionsSet = IbecorpRulesHelper.getBookingTravellersEditingActionsSet(salesContext, travelSubject);
        if (USE_TRAVELLER_NAME_FROM_DOCUMENTS_TRAVEL_SUBJECTS.contains(travelSubject)) {
            result.setUseTravellerNameFromDocuments(bookingTravellersActionsSet.isUseTravellerNameFromDocuments());
        }
        result.setForbidTravellerUpdate(bookingTravellersActionsSet.isForbidTravellerEditing());
    }

    protected static void setContactPersonData(BookingFormSettings result, PersonType authUserType, SalesContext salesContext) throws Exception {
        BookingContactActionSet bookingContactActionSet = IbecorpRulesHelper.getBookingContactActionSet(authUserType, salesContext);
        result.setContactFillingType(bookingContactActionSet.getBookingContactFillingType());
        result.setContactPersonDisableFreeTextInput(bookingContactActionSet.isDisableFreeTextInput());
        result.setContactPersonEditGranted(BaseBookingFormSettingsProcessor.isContactPersonEditGranted());
    }

    protected static void setExternalSystemsData(BookingFormSettings result, SalesContext salesContext) throws Exception {
        BookingExternalSystemsActionSet bookingExternalSystemsActionSet = IbecorpRulesHelper.getBookingExternalSystemsActionSet(salesContext);
        result.getExternalSystems().addAll(bookingExternalSystemsActionSet.getExternalSystems());
    }

    private static boolean isContactPersonEditGranted() throws Exception {
        return AclHelper.isGranted(null, (String)IbeRestrictionGroupResources.GROUP_CONTACT_PERSON.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList());
    }
}

