/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm.costCodes;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplyCostCodesToProductsAndOnlineProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Map travellersCostCodes = (Map)ctx.getObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES);
        ReasonCode reasonCode = (ReasonCode)ctx.getObject((Enum)IBusIbecorpContextKeys.REASON_CODE);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        if (travellersCostCodes == null) {
            return;
        }
        Collection reservations = MidofficeHelper.getReservations((EntityContainer)bookingCtr, CommonHelper.getReservations(ctx));
        reservations.forEach(res -> res.setType(ReservationType.IBE));
        List<BaseProduct> products = reservations.stream().flatMap(r -> r.getProducts().stream()).collect(Collectors.toList());
        products.forEach(p -> {
            ProductHandler productHandler = HandlersRegistry.get().findProductHandler(p.getClass());
            if (productHandler.isStatisticalDataAvailable(p)) {
                if (productHandler.getStatisticalData(p) == null) {
                    productHandler.newStatisticalData(p);
                }
                StatisticalData statData = productHandler.getStatisticalData(p);
                Collection travellers = productHandler.getTravellers(p);
                statData.getTravellerCostCodes().clear();
                travellers.forEach(t -> {
                    List costCodes = (List)travellersCostCodes.get(t);
                    if (null == costCodes) {
                        return;
                    }
                    TravellerCostCodes tcc = new TravellerCostCodes();
                    tcc.setTraveller(t);
                    costCodes.forEach(costCode -> tcc.getCostCodes().add(this.convert((PersonCostCode)costCode)));
                    statData.getTravellerCostCodes().add(tcc);
                });
                if (reasonCode != null && !statData.getReasonCodes().contains(reasonCode)) {
                    statData.getReasonCodes().add(reasonCode);
                }
            }
        });
    }

    private CostCode convert(PersonCostCode costCode) {
        CostCode result = new CostCode();
        try {
            XCloneModelHelper.copy((BaseEntity)costCode, (BaseEntity)result);
        }
        catch (Exception e) {
            throw new RuntimeException("cost code clone error", e);
        }
        return result;
    }
}

