/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AeroexpressService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.CommonReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class AeroexpressReservationBuilder
extends BaseReservationBuilder<CommonReservation> {
    @Override
    protected CommonReservation getInstance() {
        return new CommonReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.AEROEXPRESS;
    }

    AeroexpressReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    @Override
    protected void updateReservationData(CommonReservation result) throws Exception {
        super.updateReservationData(result);
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, AeroexpressTicket.class).filter(this::availableProduct).collect(Collectors.toList());
        for (AeroexpressTicket product : products) {
            AeroexpressService restService = new AeroexpressService();
            this.fillCommonProductData((Service)restService, (BaseProduct)product);
            restService.setTicketNumber(product.getSystemNumber());
            restService.setStartLocation(product.getDepartureLocation());
            restService.setEndLocation(product.getArrivalLocation());
            restService.setStartDate(DateUtils.toLocalDateTime((Date)product.getDepartureDate()));
            result.getServices().add(restService);
        }
    }
}

