/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.gds.model.VisaRequirement;
import com.gridnine.xtrip.common.ibecorp.common.PenaltiesResolver;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.AdditionalService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.AviaReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.AviaService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.MCO;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.McoService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.DocoDocaNeededInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAncillaryFeeSegment;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AviaReservationBuilder
extends BaseReservationBuilder<AviaReservation> {
    private final GdsCapabilities gdsCapabilities;

    @Override
    protected AviaReservation getInstance() {
        return new AviaReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.AIR;
    }

    AviaReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters, GdsCapabilities gdsCapabilities) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
        this.gdsCapabilities = gdsCapabilities;
    }

    @Override
    protected void updateReservationData(AviaReservation result) throws Exception {
        super.updateReservationData(result);
        result.setShowGdsAccountName(this.siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA));
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(this.reservation);
        result.getExchange().putAll(AviaConverterHelper.Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), this.priceComponentsParameters));
        result.getRefund().putAll(AviaConverterHelper.Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), this.priceComponentsParameters));
        Map<Traveller, List<BaseProduct>> travellerProductsMap = CommonHelper.getTravellerProductsMap(this.reservation);
        List<BaseProduct> products = travellerProductsMap.values().stream().flatMap(Collection::stream).filter(this::availableProduct).collect(Collectors.toList());
        List services = result.getServices();
        products.forEach(baseProduct -> {
            if (baseProduct instanceof Product) {
                services.add(this.convertProduct2AviaService((Product)baseProduct));
            } else if (baseProduct instanceof AdditionalServiceProduct) {
                services.add(this.convertAdditionalServiceProduct2AviaService((AdditionalServiceProduct)baseProduct));
            }
        });
        List<Leg> legs = BookingConverterHelper.buildRestAviaLegs(this.reservation, this.priceComponentsParameters);
        result.getLegs().addAll(legs);
        result.setServicesStatuses(AviaConverterHelper.convertServicesStatuses2Rest(result));
        result.setGetAncillaryFeesAvailable(this.gdsCapabilities != null && this.gdsCapabilities.isAncillaryFeesForBookingSupported() && this.permissions.isAncillaryFeesGranted() && this.reservation.getStatus() == ReservationStatus.BOOKING);
        GDSHelper.getMcoProducts((Reservation)this.reservation).stream().filter(this::availableProduct).filter(pr -> !BookingConverterHelper.isFlyArystanPackage(pr)).map(prod -> this.convertToMcoService((Product)prod, legs)).filter(Objects::nonNull).forEach(result.getMcoServices()::add);
        if (!this.reservation.getVisaRequirements().isEmpty()) {
            result.setDocoDocaNeededInfo(this.getDocoDocaNeededInfo((VisaRequirement)this.reservation.getVisaRequirements().get(0)));
        }
    }

    private AviaService convertProduct2AviaService(Product product) {
        Date firstDepartureDate;
        AviaService result = new AviaService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        if (this.permissions.isCertificateOfCompletedFlightCreationPermitted() && (firstDepartureDate = AirProductHelper.getFirstDepartureDate((Product)product)) != null) {
            result.setCertificateOfCompletedFlightCreationPossible(product.getStatus() == ProductStatus.SELL && firstDepartureDate.before(new Date()));
        }
        result.setTicketNumber(product.getSystemNumber());
        if (product.getProductCategory() == ProductCategory.MCO) {
            MCO mco = new MCO();
            mco.setCategory(product.getMcoCategory());
            product.getRelatedProducts().stream().map(this::getAvailableProduct).map(BaseIdentity::getUid).forEach(mco.getRelated()::add);
            result.setMco(mco);
        }
        boolean effectiveProduct = AirProductHelper.isEffectiveProduct((Product)product);
        result.setRefundable(this.isValidOnlineBooking && effectiveProduct);
        result.setExchangeable(this.isValidOnlineBooking && effectiveProduct && this.permissions.isExchangeGranted());
        return result;
    }

    private AviaService convertAdditionalServiceProduct2AviaService(AdditionalServiceProduct product) {
        AviaService result = new AviaService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        result.setTicketNumber(product.getSystemNumber());
        AdditionalService additionalService = new AdditionalService();
        product.getRelatedProducts().stream().map(BaseIdentity::getUid).forEach(additionalService.getRelated()::add);
        additionalService.setCategory(product.getCategory());
        result.setAdditionalService(additionalService);
        return result;
    }

    private McoService convertToMcoService(Product product, List<Leg> legs) {
        if (product.getProductCategory() != ProductCategory.MCO) {
            return null;
        }
        McoService result = new McoService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        result.setGdsId(product.getGdsId());
        result.setMcoStatus(product.getMcoReservationRequestStatus());
        result.setMcoCategory(product.getMcoCategory());
        result.setMcoNumber(product.getSystemNumber());
        if (product.getAncillaryFeeDescription() != null) {
            result.setDescription(product.getAncillaryFeeDescription().toString());
            AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)DictionaryCache.get().resolveReference(product.getAncillaryFeeDescription());
            result.setAncillaryFeeType(ancillaryFeeDescription.getType());
        } else {
            result.setDescription(product.getGdsDescription());
        }
        XtripPriceStructure priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)true);
        result.setPrice(CommonConverterHelper.convertMoney2Rest(priceStructure.getTotal(), this.priceComponentsParameters.getCurrency()));
        List segments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs());
        List restSegments = segments.stream().map(seg -> this.buildRestAncillaryFeeSegment((Segment)seg, legs)).collect(Collectors.toList());
        if (!restSegments.contains(null)) {
            result.getSegments().addAll(restSegments);
        }
        result.setCancelAllowed(product.getStatus() == ProductStatus.BOOKING && product.isMcoCancellationAllowed());
        return result;
    }

    private RestAncillaryFeeSegment buildRestAncillaryFeeSegment(Segment seg, List<Leg> legs) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment rs = AviaConverterHelper.convertBaseSegmentInfo2Rest(seg);
        for (int legInd = 0; legInd < legs.size(); ++legInd) {
            Leg leg = legs.get(legInd);
            for (int segInd = 0; segInd < leg.getSegments().size(); ++segInd) {
                com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment restSeg = (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment)leg.getSegments().get(segInd);
                if (!AviaHelper.isSameSegment(rs, restSeg)) continue;
                RestAncillaryFeeSegment result = new RestAncillaryFeeSegment();
                result.setLegIndex(legInd);
                result.setSegmentIndex(segInd);
                return result;
            }
        }
        return null;
    }

    private DocoDocaNeededInfo getDocoDocaNeededInfo(VisaRequirement visaRequirement) {
        if (visaRequirement.isDocaNeeded() || visaRequirement.isDocoNeeded()) {
            DocoDocaNeededInfo result = new DocoDocaNeededInfo();
            result.setCountry(visaRequirement.getCountry());
            result.setDocaNeeded(visaRequirement.isDocaNeeded());
            result.setDocoNeeded(visaRequirement.isDocoNeeded());
            return result;
        }
        return null;
    }
}

