/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IntentionStatus;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AuthorizationStep;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AuthorizationUnit;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BaseReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ReservationTravelPolicyStatus;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ServiceStatistics;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ServiceStatus;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.ServiceTravellerStatistics;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.TravellerInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.TravellerPassportInfo;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.cancelBooking.CancelBookingHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class BaseReservationBuilder<R extends BaseReservation> {
    protected final Reservation reservation;
    protected final EntityContainer<? extends BaseGdsAccount> gdsAccountCtr;
    protected final SMGeneralSettings generalSettings;
    protected final BookingPermissions permissions;
    protected final PriceComponentsParameters priceComponentsParameters;
    protected SMSiteType siteType;
    protected boolean isValidOnlineBooking;
    private static final Set<ProductStatus> ALWAYS_DISPLAYED_PRODUCT_STATUSES = EnumSet.of(ProductStatus.EXCHANGE, ProductStatus.REFUND);

    BaseReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        this.reservation = reservation;
        this.generalSettings = generalSettings;
        this.permissions = permissions;
        this.priceComponentsParameters = priceComponentsParameters;
        this.gdsAccountCtr = EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount());
    }

    public BaseReservationBuilder setSiteType(SMSiteType siteType) {
        this.siteType = siteType;
        return this;
    }

    protected abstract R getInstance();

    protected abstract boolean isAppropriate(BaseProduct var1);

    protected R build() {
        R result = this.getInstance();
        try {
            if (this.reservation.getProducts().stream().noneMatch(this::isAppropriate)) {
                return null;
            }
            this.updateReservationData(result);
        }
        catch (Exception e) {
            result.setIncomplete(true);
            IncidentsLog.reportException((String)("rest reservation build failed for booking " + this.reservation.getBookingFile().getNumber() + ", reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation)), (Throwable)e);
        }
        return result;
    }

    protected void updateReservationData(R result) throws Exception {
        Set allProductStatuses;
        result.setUid(this.reservation.getUid());
        result.setPrn(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation));
        result.setMainReservation(RzdCommonHelper.getFirstReservation((Reservation)this.reservation).getUid());
        result.setPaid(DateUtils.toLocalDateTime((Date)this.getPayDate(this.reservation)));
        if (this.gdsAccountCtr != null) {
            result.setGds(((BaseGdsAccount)this.gdsAccountCtr.getEntity()).getGds());
            result.setGdsAccountName(((BaseGdsAccount)this.gdsAccountCtr.getEntity()).getName());
        }
        this.setPriceData(result);
        TravelSubject travelSubject = this.reservation.getProducts().stream().filter(this::isAppropriate).findFirst().map(bp -> ProductHandler.of((BaseProduct)bp).findTravelSubject(bp)).orElse(null);
        result.setTravelSubject(travelSubject);
        if (this.reservation.getProducts().stream().filter(this::isAppropriate).anyMatch(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.BOOKING)) {
            LocalDateTime correctTimeLimit = CommonHelper.getCorrectTimeLimit(this.reservation, this.generalSettings);
            result.setTimeLimit(correctTimeLimit);
            if (correctTimeLimit != null) {
                result.setTimeExpirationMinutes(ChronoUnit.MINUTES.between(LocalDateTime.now(), correctTimeLimit));
            }
            result.setTimeLimitCity(CommonConverterHelper.getTimeLimitCity(this.generalSettings));
        }
        ReservationTravelPolicyStatus travelPolicyStatus = this.getTravelPolicyStatus(this.reservation);
        result.setTravelPolicyStatus(travelPolicyStatus);
        if (travelPolicyStatus == ReservationTravelPolicyStatus.AUTHORIZATION_REQUESTED) {
            boolean existsWaitingProductsForAgent = TravelPolicyAuthorizationHelper.isExistsWaitingProductsForAgent((Reservation)this.reservation, (EntityReference)((EntityReference)MiscUtil.guarded(this.priceComponentsParameters.getAuthorizedUserRef(), ProfileHelper::getCurrentUser)));
            result.setApproveAuthorizationAllowed(existsWaitingProductsForAgent);
            result.setRefuseAuthorizationAllowed(existsWaitingProductsForAgent);
        }
        ReservationStatus reservationStatus = CommonIbecorpHelper.getReservationStatus((Reservation)this.reservation);
        result.setStatus(reservationStatus);
        if (this.reservation.getStatus() == ReservationStatus.PROPOSAL) {
            result.setIntentionVariantNotFound(this.reservation.getIntentionStatus() == IntentionStatus.VARIANT_NOT_FOUND);
            result.setIntentionVariantPriceChanged(this.reservation.getIntentionStatus() == IntentionStatus.VARIANT_PRICE_CHANGED);
            result.setApprovalNeeded(this.permissions.isApprovalGranted() && this.permissions.isIssueGranted() ? Boolean.valueOf(true) : null);
        }
        if (this.reservation.getStatus() == ReservationStatus.AUTHORIZATION && travelPolicyStatus == ReservationTravelPolicyStatus.AUTHORIZATION_APPROVED) {
            result.setBookAuthorizationAllowed(true);
        }
        boolean invalidProductStatuses = (allProductStatuses = this.reservation.getProducts().stream().map(BookingHelper::getProductStatus).collect(Collectors.toSet())).contains(ProductStatus.BOOKING) && allProductStatuses.size() > 1;
        boolean bl = this.isValidOnlineBooking = this.isValidGdsAccount() && (this.reservation.getType() == ReservationType.INTERNET || this.reservation.getType() == ReservationType.IBE) && reservationStatus != ReservationStatus.ERROR && !invalidProductStatuses;
        if (this.isValidOnlineBooking) {
            result.setOnlineBooking(true);
            Set<ProductStatus> productStatuses = this.reservation.getProducts().stream().filter(this::isAppropriate).filter(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION).map(BookingHelper::getProductStatus).filter(Predicate.isEqual(ProductStatus.SELL).or(Predicate.isEqual(ProductStatus.BOOKING)).or(Predicate.isEqual(ProductStatus.INTENTION))).collect(Collectors.toSet());
            result.setCancelBookingAllowed(this.isCancelBookingAllowed(this.reservation));
            boolean isFakeReservation = reservationStatus == ReservationStatus.AUTHORIZATION || reservationStatus == ReservationStatus.PROPOSAL;
            result.setIssueAllowed(!isFakeReservation && this.isIssueAllowed(productStatuses));
            result.setVoidBookingAllowed(travelSubject == TravelSubject.AIR && this.permissions.isVoidGranted() && !this.permissions.isVoidInRefund());
            result.setRefundBookingAllowed(productStatuses.contains(ProductStatus.SELL) && this.permissions.isRefundGranted());
        }
    }

    protected boolean isValidGdsAccount() {
        return this.gdsAccountCtr != null;
    }

    private ReservationTravelPolicyStatus getTravelPolicyStatus(Reservation reservation) {
        if (!TravelPolicyAuthorizationHelper.hasAuthorization((Reservation)reservation)) {
            return null;
        }
        TravelPolicyAuthorizationStatus authorizationStatus = TravelPolicyAuthorizationHelper.getAuthorizationStatus((Reservation)reservation);
        if (authorizationStatus == null) {
            return reservation.getStatus() == ReservationStatus.CANCELED ? ReservationTravelPolicyStatus.AUTHORIZATION_NOT_APPROVED : ReservationTravelPolicyStatus.AUTHORIZATION_NEEDED;
        }
        if (authorizationStatus == TravelPolicyAuthorizationStatus.WAIT) {
            return ReservationTravelPolicyStatus.AUTHORIZATION_REQUESTED;
        }
        if (authorizationStatus == TravelPolicyAuthorizationStatus.APPROVED) {
            return ReservationTravelPolicyStatus.AUTHORIZATION_APPROVED;
        }
        if (authorizationStatus == TravelPolicyAuthorizationStatus.COMPLETED) {
            return ReservationTravelPolicyStatus.AUTHORIZATION_APPROVED;
        }
        return ReservationTravelPolicyStatus.AUTHORIZATION_NOT_APPROVED;
    }

    protected boolean isIssueAllowed(Set<ProductStatus> productStatuses) {
        return productStatuses.contains(ProductStatus.BOOKING) && this.permissions.isIssueGranted();
    }

    protected boolean isCancelBookingAllowed(Reservation reservation) {
        return CancelBookingHelper.isCancelBookingAllowed(reservation) && this.permissions.isCancelGranted();
    }

    protected void setPriceData(R result) {
        result.setPrice(ReservationPriceComponents.builder(this.reservation, this.priceComponentsParameters).setProductFilter(this::isAppropriate).build().createPrice());
        result.setTotalPrice(result.getPrice().getTotal());
    }

    private Date getPayDate(Reservation reservation) {
        Date result = null;
        for (BaseProduct bp : reservation.getProducts()) {
            ProductHandler h;
            ProductStatus status;
            if (!this.isAppropriate(bp) || (status = (h = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)bp))).getStatus(bp)) != ProductStatus.SELL && status != ProductStatus.REQUEST || h.getNextProduct(bp) != null) continue;
            List clientFops = GeneralProductHelper.getClientFops((BaseProduct)bp);
            for (GeneralProductFop clientFop : clientFops) {
                Date operationDate = clientFop.getOperationDate();
                if (operationDate == null) {
                    return null;
                }
                result = result == null ? operationDate : MiscUtil.minimum((Date[])new Date[]{result, operationDate});
            }
        }
        return result;
    }

    protected boolean availableProduct(BaseProduct baseProduct) {
        ProductHandler ph = ProductHandler.of((BaseProduct)baseProduct);
        boolean hasNextAvailable = this.getNextAvailable(baseProduct) != null;
        return ph.getTicketType(baseProduct) != TicketType.CORRECTION && !hasNextAvailable;
    }

    protected BaseProduct getAvailableProduct(BaseProduct baseProduct) {
        return (BaseProduct)MiscUtil.guarded((Object)this.getNextAvailable(baseProduct), (Object)baseProduct);
    }

    private BaseProduct getNextAvailable(BaseProduct baseProduct) {
        ProductHandler ph = ProductHandler.of((BaseProduct)baseProduct);
        ProductStatus status = ph.getStatus(baseProduct);
        if (ALWAYS_DISPLAYED_PRODUCT_STATUSES.contains(status)) {
            return null;
        }
        return ph.getNextProduct(baseProduct);
    }

    protected void fillCommonProductData(Service service, BaseProduct product) {
        this.fillCommonProductData(service, product, false);
    }

    protected void fillCommonProductData(Service service, BaseProduct product, boolean skipTravellerDetails) {
        service.setUid(product.getUid());
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        service.setStatus(BaseReservationBuilder.getServiceStatus(product));
        service.setTripartiteDiscount(handler.isTripartiteDiscount(product));
        CommonConverterHelper.addTravelPolicyInfo(TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product), (HasTravelPolicyCompliance)service);
        for (Traveller traveller : handler.getTravellers(product)) {
            DictionaryReference passengerType = handler.getPassengerType(product, traveller);
            service.getTravellers().add(BaseReservationBuilder.convertTraveller2TravellerInfo(traveller, (DictionaryReference<PassengerType>)passengerType, skipTravellerDetails));
        }
        if (TravelPolicyAuthorizationHelper.hasAuthorization((BaseProduct)product)) {
            service.setAuthorizationStatus(TravelPolicyAuthorizationHelper.getAuthorizationStatus((BaseProduct)product));
            TravelPolicyAuthorizationHelper.getAuthorizationSteps((BaseProduct)product).stream().map(this::convertAuthorizationStep).forEach(service.getAuthorizationSteps()::add);
        }
        service.setAclViewGranted(false);
        service.setAclEditGranted(false);
        RestrictionResourceProxy aclProxy = this.permissions.getAclProxyMap().get(product.getUid());
        if (aclProxy != null) {
            try {
                String currentLogin = UserData.get().getCurrentUser();
                service.setAclViewGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList()));
                service.setAclEditGranted(AclHelper.isGranted((RestrictionResourceProxy)aclProxy, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (String)currentLogin, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()));
            }
            catch (Exception e) {
                IncidentsLog.reportException((String)("AclHelper.isGranted failed for " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation) + ", product " + product.getUid()), (Throwable)e);
            }
        }
        if (!skipTravellerDetails) {
            service.setStatistics(BaseReservationBuilder.buildServiceStatistics(product, (ProductHandler<BaseProduct>)handler));
        }
    }

    private AuthorizationStep convertAuthorizationStep(TravelPolicyAuthorizationStepParameters step) {
        AuthorizationStep result = new AuthorizationStep();
        result.setStatus(TravelPolicyAuthorizationHelper.getAuthorizationStatus((TravelPolicyAuthorizationStepParameters)step));
        result.setName(step.getName());
        result.setSendDate(TravelPolicyAuthorizationHelper.getAuthorizationSendDate((TravelPolicyAuthorizationStepParameters)step));
        step.getUnits().stream().map(this::convertAuthorizationUnit).forEach(result.getUnits()::add);
        return result;
    }

    private AuthorizationUnit convertAuthorizationUnit(TravelPolicyAuthorizationUnitParameters unit) {
        TravelPolicyUnitAuthorization unitAuthorization;
        AuthorizationUnit result = new AuthorizationUnit();
        result.getAuthorizationSendPersons().addAll(unit.getPersons());
        if (unit.getAppliedRule() != null) {
            result.setRuleDescription(unit.getAppliedRule().getRuleDescription());
        }
        if ((unitAuthorization = unit.getUnitAuthorization()) != null) {
            result.setStatus(unitAuthorization.getStatus());
            result.setAuthorizer(unitAuthorization.getAuthorizer());
            result.setOperationDate(unitAuthorization.getOperationDate());
        }
        return result;
    }

    private static ServiceStatus getServiceStatus(BaseProduct product) {
        ProductStatus productStatus = ProductHandler.of((BaseProduct)product).getStatus(product);
        Reservation reservation = product.getReservation();
        ReservationStatus reservationStatus = reservation.getStatus();
        TravelPolicyAuthorizationStatus travelPolicyAuthorizationStatus = TravelPolicyAuthorizationHelper.getAuthorizationStatus((BaseProduct)product);
        boolean isVoidIntention = productStatus == ProductStatus.VOID_INTENTION;
        boolean isProductAuthorization = TravelPolicyAuthorizationHelper.isAuthorization((BaseProduct)product);
        boolean isReservationAuthorization = TravelPolicyAuthorizationHelper.isAuthorization((Reservation)reservation);
        if (productStatus != null) {
            switch (productStatus) {
                case BOOKING: {
                    return ServiceStatus.BOOKING;
                }
                case REFUND: {
                    return ServiceStatus.REFUND;
                }
                case REJECT: {
                    return ServiceStatus.REJECT;
                }
                case REQUEST: {
                    return ServiceStatus.REQUEST;
                }
                case VOID_REQUEST: {
                    return ServiceStatus.CANCELED_REQUEST;
                }
                case VOID_BOOKING: {
                    return ServiceStatus.VOID_BOOKING;
                }
                case SELL: {
                    return ServiceStatus.SELL;
                }
                case VOID: {
                    return ServiceStatus.VOID;
                }
                case EXCHANGE: {
                    return ServiceStatus.EXCHANGE;
                }
                case INTENTION: {
                    if (reservationStatus != null) {
                        switch (reservationStatus) {
                            case PROPOSAL: {
                                return ServiceStatus.PROPOSAL;
                            }
                            case AUTHORIZATION: {
                                return BaseReservationBuilder.convertAuthorizationStatus(travelPolicyAuthorizationStatus, isProductAuthorization, isVoidIntention);
                            }
                            case INTENTION: {
                                return ServiceStatus.INTENTION;
                            }
                            case ERROR: {
                                if (reservation.isProposal()) {
                                    return ServiceStatus.PROPOSAL;
                                }
                                if (isReservationAuthorization) {
                                    return BaseReservationBuilder.convertAuthorizationStatus(travelPolicyAuthorizationStatus, isProductAuthorization, isVoidIntention);
                                }
                                return ServiceStatus.INTENTION;
                            }
                        }
                    }
                }
                case VOID_INTENTION: {
                    if (reservation.isProposal()) {
                        return ServiceStatus.CANCELED_PROPOSAL;
                    }
                    if (isReservationAuthorization) {
                        return BaseReservationBuilder.convertAuthorizationStatus(travelPolicyAuthorizationStatus, isProductAuthorization, isVoidIntention);
                    }
                    return ServiceStatus.CANCELED_INTENTION;
                }
            }
        }
        return null;
    }

    private static ServiceStatus convertAuthorizationStatus(TravelPolicyAuthorizationStatus authorizationStatus, boolean isAuthorization, boolean isVoidIntention) {
        if (authorizationStatus == null) {
            if (isVoidIntention) {
                return isAuthorization ? ServiceStatus.AUTHORIZATION_DELETED : ServiceStatus.AUTHORIZATION_NOT_NEEDED;
            }
            return isAuthorization ? ServiceStatus.AUTHORIZATION_NEEDED : ServiceStatus.AUTHORIZATION_NOT_NEEDED;
        }
        switch (authorizationStatus) {
            case WAIT: {
                return ServiceStatus.AUTHORIZATION_REQUESTED;
            }
            case APPROVED: {
                return ServiceStatus.AUTHORIZATION_APPROVED;
            }
            case ABORTED: {
                return ServiceStatus.AUTHORIZATION_ABORTED;
            }
            case REFUSED: {
                return ServiceStatus.AUTHORIZATION_REFUSED;
            }
            case EXPIRED: {
                return ServiceStatus.AUTHORIZATION_EXPIRED;
            }
            case CANCELED: {
                return ServiceStatus.AUTHORIZATION_CANCELED;
            }
        }
        return null;
    }

    private static TravellerInfo convertTraveller2TravellerInfo(Traveller traveller, DictionaryReference<PassengerType> passengerType, boolean skipDetails) {
        if (traveller == null) {
            return null;
        }
        TravellerInfo result = new TravellerInfo();
        result.setUid(traveller.getUid());
        result.setFullName(traveller.getName());
        result.setTravellerType(passengerType);
        result.setPerson(traveller.getPassenger());
        if (!skipDetails) {
            if (traveller.getPassport() != null) {
                result.setPassportInfo(BaseReservationBuilder.convertPassport2TravellerPassportInfo(traveller.getPassport()));
            }
            if (!traveller.getDocaInformations().isEmpty()) {
                result.getDocaInfos().addAll(AviaConverterHelper.convertDocaInformation(traveller.getDocaInformations()));
            }
            if (!traveller.getDocoInformations().isEmpty()) {
                result.getDocoInfos().addAll(AviaConverterHelper.convertDocoInformation(traveller.getDocoInformations()));
            } else if (traveller.isVisaNotNeeded()) {
                DocoInfo docoInfo = new DocoInfo();
                docoInfo.setVisa(false);
                result.getDocoInfos().add(docoInfo);
            }
        }
        return result;
    }

    private static TravellerPassportInfo convertPassport2TravellerPassportInfo(Passport passport) {
        TravellerPassportInfo result = new TravellerPassportInfo();
        if (passport.getType() != PassportType.INTERNAL) {
            result.setExpiredDate(DateUtils.toLocalDate((Date)passport.getExpired()));
        }
        result.setNumber(passport.getNumber());
        result.setBirthday(DateUtils.toLocalDate((Date)passport.getBirthday()));
        result.setType(passport.getType());
        return result;
    }

    private static ServiceStatistics buildServiceStatistics(BaseProduct product, ProductHandler<BaseProduct> handler) {
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (statisticalData == null) {
            return null;
        }
        ServiceStatistics result = new ServiceStatistics();
        List travellerCostCodes = statisticalData.getTravellerCostCodes();
        if (!travellerCostCodes.isEmpty()) {
            List firstTravellerCostCodes = ((TravellerCostCodes)travellerCostCodes.get(0)).getCostCodes();
            BaseReservationBuilder.addCommonCostCodes(result, firstTravellerCostCodes);
            travellerCostCodes.forEach(tcc -> BaseReservationBuilder.addTravellerCostCodes(result, tcc.getCostCodes(), tcc.getTraveller()));
        }
        return result;
    }

    private static void addCommonCostCodes(ServiceStatistics result, List<CostCode> costCodes) {
        for (CostCode costCode : costCodes) {
            CostCodeProperties costCodeProperties = costCode.getCostCodeProperties();
            if (costCodeProperties == null || !costCodeProperties.isCommon()) continue;
            result.getCommonCostCodes().add(CommonConverterHelper.convertCostCodeToRest(costCode));
        }
    }

    private static void addTravellerCostCodes(ServiceStatistics result, List<CostCode> costCodes, Traveller traveller) {
        ServiceTravellerStatistics travellerStatistics = null;
        for (CostCode costCode : costCodes) {
            CostCodeProperties costCodeProperties = costCode.getCostCodeProperties();
            if (costCodeProperties == null || costCodeProperties.isCommon()) continue;
            if (travellerStatistics == null) {
                travellerStatistics = new ServiceTravellerStatistics();
                travellerStatistics.setTravellerUid(traveller.getUid());
                travellerStatistics.setTravellerName(traveller.getName());
            }
            travellerStatistics.getCostCodes().add(CommonConverterHelper.convertCostCodeToRest(costCode));
        }
        if (travellerStatistics != null) {
            result.getTravellerStatistics().add(travellerStatistics);
        }
    }
}

