/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BusReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BusService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RestBusSegment;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class BusReservationBuilder
extends BaseReservationBuilder<BusReservation> {
    @Override
    protected BusReservation getInstance() {
        return new BusReservation();
    }

    BusReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.BUS;
    }

    @Override
    protected void updateReservationData(BusReservation result) throws Exception {
        super.updateReservationData(result);
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, BusProduct.class).filter(this::availableProduct).collect(Collectors.toList());
        BusProduct firstProduct = (BusProduct)CollectionUtil.head(products);
        if (firstProduct != null) {
            for (BusSegment busSegment : firstProduct.getSegments()) {
                RestBusSegment restSegment = new RestBusSegment();
                restSegment.setDepartureLocation(busSegment.getDeparture());
                restSegment.setArrivalLocation(busSegment.getArrival());
                restSegment.setDepartureAddress(busSegment.getDepartureAddress());
                restSegment.setArrivalAddress(busSegment.getArrivalAddress());
                restSegment.setDepartureDate(DateUtils.toLocalDateTime((Date)busSegment.getDepartureDate()));
                restSegment.setArrivalDate(DateUtils.toLocalDateTime((Date)busSegment.getArrivalDate()));
                result.getSegments().add(restSegment);
            }
        }
        for (BusProduct product : products) {
            BusService restService = new BusService();
            this.fillCommonProductData((Service)restService, (BaseProduct)product);
            restService.setTicketNumber(product.getSystemNumber());
            result.getServices().add(restService);
        }
    }
}

