/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.CommonService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.CommonReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class CommonReservationBuilder
extends BaseReservationBuilder<CommonReservation> {
    private static final Set<TravelSubject> AVAILABLE_TRAVEL_SUBJECTS = EnumSet.of(TravelSubject.OTHER, TravelSubject.ADDITIONAL_SERVICE);

    @Override
    protected CommonReservation getInstance() {
        return new CommonReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        ProductHandler ph = ProductHandler.of((BaseProduct)bp);
        TravelSubject travelSubject = ph.findTravelSubject(bp);
        if (travelSubject == null) {
            return true;
        }
        if (!AVAILABLE_TRAVEL_SUBJECTS.contains(travelSubject)) {
            return false;
        }
        boolean hasMainProductInSameReservation = ph.getRelatedProducts(bp).stream().map(BaseProduct::getReservation).filter(Objects::nonNull).anyMatch(arg_0 -> ((Reservation)bp.getReservation()).equals(arg_0));
        if (hasMainProductInSameReservation) {
            return false;
        }
        return !(bp instanceof UniversalProduct);
    }

    CommonReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    @Override
    protected void updateReservationData(CommonReservation result) throws Exception {
        super.updateReservationData(result);
        try {
            for (BaseProduct baseProduct : this.reservation.getProducts()) {
                if (!this.isAppropriate(baseProduct) || !this.availableProduct(baseProduct)) continue;
                CommonService commonService = new CommonService();
                this.fillCommonProductData((Service)commonService, baseProduct);
                result.getServices().add(commonService);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

