/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.ibecorp.AirAllowingHelper;
import com.gridnine.xtrip.common.ibecorp.IbeCorpSalesContextHandler;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.AirPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingInfoValidationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.AeroexpressReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.AviaReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BusReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.CarRentalReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.CommonReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.HotelReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.InsuranceAccidentReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.InsuranceTouristicReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.RailwayReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.TaxiReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.TransferReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.UniversalReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.VisaReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.Messages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.CommonReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Order;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class GetBookingInfoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference userRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        EntityContainer userCtr = (EntityContainer)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        EntityReference currentOrgRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        Map gdsCapabilitiesMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES_MAP);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        BookingInfoValidationHelper.commonBookingValidate(bookingFile, messages);
        Order order = BookingConverterHelper.convertBookingFile2Order((EntityContainer<BookingFile>)bookingFileCtr, salesContext, (EntityContainer<Person>)userCtr);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)userRef, salesContext);
        Map aclProxyMap = RestrictionsHelper.buildProxies((EntityContainer)bookingFileCtr, (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
        boolean isBookingEditGranted = IbePermissionManager.isEntityGranted(bookingFileCtr, aclProxyMap, StandardRestrictionResourceOperations.EDIT);
        boolean isAgency = siteType == SMSiteType.B2B && currentOrgRef.equals((Object)priceComponentsParameters.getSalesContext().getAgency()) || currentOrgRef.equals((Object)priceComponentsParameters.getSalesContext().getSubagency());
        for (Reservation reservation : bookingFile.getReservations()) {
            BookingPermissions permissions;
            if (reservation.getProducts().stream().noneMatch(prod -> ProductHandler.of((BaseProduct)prod).getTicketType(prod) != TicketType.CORRECTION)) continue;
            List travelSubjects = reservation.getProducts().stream().map(pr -> ProductHandler.of((BaseProduct)pr).findTravelSubject(pr)).distinct().collect(Collectors.toList());
            if (travelSubjects.size() > 1) {
                permissions = BookingPermissions.builder().setAclProxyMap(aclProxyMap).build();
            } else if (siteType == SMSiteType.B2B) {
                IbecorpActionSet reservationPermissions = isBookingEditGranted ? AirAllowingHelper.getReservationCancelVoidTargetPermissions((SalesContext)salesContext, (Reservation)reservation) : new IbecorpActionSet();
                BookingPermissions.BookingPermissionsBuilder permissionsBuilder = BookingPermissions.builder().setCancelGranted(BooleanUtils.isTrue((Boolean)reservationPermissions.isReservationCancelPermitted())).setVoidGranted(BooleanUtils.isTrue((Boolean)reservationPermissions.isTicketVoidingPermitted())).setRefundGranted(BooleanUtils.isTrue((Boolean)reservationPermissions.getTicketRefundPermitted())).setVoidInRefund(BooleanUtils.isTrue((Boolean)reservationPermissions.getVoidInRefund())).setExchangeGranted(AirAllowingHelper.getTicketExchangePermissions((SalesContext)salesContext, (Reservation)reservation)).setIssueGranted(ApprovalHelper.isIssueGranted()).setApprovalGranted(ApprovalHelper.isApprovalGranted()).setAclProxyMap(aclProxyMap);
                this.updateAdditionalServicesPermissions(permissionsBuilder, salesContext, reservation);
                permissions = permissionsBuilder.build();
            } else {
                permissions = BookingPermissions.builder().setCancelGranted(true).setVoidGranted(false).setExchangeGranted(false).setIssueGranted(true).setApprovalGranted(false).setCertificateOfCompletedFlightCreationPermitted(false).setAclProxyMap(aclProxyMap).build();
            }
            GdsCapabilities gdsCapabilities = (GdsCapabilities)gdsCapabilitiesMap.get(reservation.getGdsNameInfo().getOnlineGdsAccount());
            boolean commonReservationAdded = false;
            block15: for (TravelSubject travelSubject : travelSubjects) {
                CommonReservation restReservation;
                if (travelSubject == null) {
                    CommonReservation restReservation2;
                    if (commonReservationAdded || (restReservation2 = (CommonReservation)new CommonReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).build()) == null) continue;
                    order.getReservations().add(restReservation2);
                    commonReservationAdded = true;
                    continue;
                }
                switch (travelSubject) {
                    case AIR: {
                        order.getReservations().add(new AviaReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters, gdsCapabilities).setSiteType(siteType).build());
                        continue block15;
                    }
                    case RAILWAY: {
                        order.getReservations().add(new RailwayReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case HOTEL_RESERVATION: {
                        order.getReservations().add(new HotelReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setBookingFileRef((EntityReference<BookingFile>)bookingFileCtr.toReference()).setAgency(isAgency).setSiteType(siteType).build());
                        continue block15;
                    }
                    case TRANSFER: {
                        order.getReservations().add(new TransferReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case BUS: {
                        order.getReservations().add(new BusReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).build());
                        continue block15;
                    }
                    case CAR_RENTAL: {
                        order.getReservations().add(new CarRentalReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case TAXI: {
                        order.getReservations().add(new TaxiReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case AEROEXPRESS: {
                        order.getReservations().add(new AeroexpressReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case VISA: {
                        order.getReservations().add(new VisaReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case INSURANCE_ACCIDENT: {
                        order.getReservations().add(new InsuranceAccidentReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case INSURANCE_TOURISTIC: {
                        order.getReservations().add(new InsuranceTouristicReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).setSiteType(siteType).build());
                        continue block15;
                    }
                    case OTHER: {
                        List universalProducts = BookingStreamHelper.getProductsStream((Reservation)reservation, UniversalProduct.class).collect(Collectors.toList());
                        if (universalProducts.isEmpty()) break;
                        Set uniProductDescRefs = universalProducts.stream().map(UniversalProduct::getDescription).filter(Objects::nonNull).collect(Collectors.toSet());
                        for (EntityReference descRef : uniProductDescRefs) {
                            order.getReservations().add(new UniversalReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters, (EntityReference<UniversalProductDescription>)descRef).setSiteType(siteType).build());
                        }
                        break;
                    }
                }
                if (commonReservationAdded || (restReservation = (CommonReservation)new CommonReservationBuilder(reservation, generalSettings, permissions, priceComponentsParameters).build()) == null) continue;
                order.getReservations().add(restReservation);
                commonReservationAdded = true;
            }
        }
        if (CollectionUtil.isNotEmpty(messages)) {
            B2BRestHelper.addMessage(ctx, Messages.getNotFilled());
            BookingInfoValidationHelper.createdLog((EntityContainer<BookingFile>)bookingFileCtr, messages);
        }
        BookingResult result = new BookingResult();
        result.setOrder(order);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void updateAdditionalServicesPermissions(BookingPermissions.BookingPermissionsBuilder permissionsBuilder, SalesContext salesContext, Reservation reservation) throws Exception {
        IbeCorpSalesContextHandler handler = (IbeCorpSalesContextHandler)SalesContextHandler.get();
        RuleProxy proxy = new RuleProxy();
        proxy.setActionSet((Object)new IbecorpActionSet());
        proxy.setProxyType(Targets.ADDITIONAL_SERVICES.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new AirPropertySet(reservation));
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)handler.getRules(salesContext));
        IbecorpActionSet actionSet = (IbecorpActionSet)proxy.getActionSet();
        List allowedAdditionalServiceCategories = actionSet.getAllowedAdditionalServiceCategories();
        permissionsBuilder.setCertificateOfCompletedFlightCreationPermitted(allowedAdditionalServiceCategories.contains(AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT));
        permissionsBuilder.setAncillaryFeesGranted(BooleanUtils.isTrue((Boolean)actionSet.getAncillaryFeesPermitted()));
    }
}

