/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelService;
import com.gridnine.xtrip.server.ibecorp.common.components.HotelPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HotelReservationBuilder
extends BaseReservationBuilder<HotelReservation> {
    private EntityReference<BookingFile> bookingFileRef;
    private boolean isAgency;

    @Override
    protected HotelReservation getInstance() {
        return new HotelReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.HOTEL_RESERVATION;
    }

    HotelReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    public HotelReservationBuilder setBookingFileRef(EntityReference<BookingFile> bookingFileRef) {
        this.bookingFileRef = bookingFileRef;
        return this;
    }

    public HotelReservationBuilder setAgency(boolean agency) {
        this.isAgency = agency;
        return this;
    }

    @Override
    protected void updateReservationData(HotelReservation result) throws Exception {
        super.updateReservationData(result);
        result.setShowGdsAccountName(this.siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_HOTELS));
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, HotelProduct.class).filter(this::availableProduct).collect(Collectors.toList());
        if (!products.isEmpty()) {
            result.setCard(HotelsConverterHelper.convertHotelCard(this.reservation));
            List services = result.getServices();
            EntityReference clientRef = this.reservation.getBookingFile().getCustomerProfile();
            Collection persons = this.reservation.getProducts().stream().filter(p -> p instanceof HotelProduct).flatMap(p -> ((HotelProduct)p).getTravellers().stream()).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toSet());
            products.stream().filter(this::availableProduct).map(ExceptionUtil.wrapFunction(p -> this.convertHotelProduct2HotelService((HotelProduct)p, (EntityReference<Organization>)clientRef, persons))).forEach(services::add);
        }
        result.setCommentAllowed(products.stream().filter(p -> p.getNextProduct() == null).allMatch(HotelProduct::isCommentAllowed));
    }

    @Override
    protected boolean isValidGdsAccount() {
        return this.gdsAccountCtr != null || HotelsReservationHelper.isDirectContract((Reservation)this.reservation);
    }

    @Override
    protected boolean isIssueAllowed(Set<ProductStatus> productStatuses) {
        return productStatuses.contains(ProductStatus.INTENTION) && this.permissions.isIssueGranted();
    }

    private HotelService convertHotelProduct2HotelService(HotelProduct product, EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons) throws Exception {
        HotelService result = new HotelService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        HotelOffer offer = HotelsConverterHelper.buildHotelOffer(product);
        if (offer != null) {
            Price price = HotelPriceComponents.builder(offer, this.priceComponentsParameters).build().createPrice();
            LocalDate checkIn = Objects.requireNonNull(DateUtils.toLocalDate((Date)HotelProductHelper.getCheckInDate((HotelProduct)product)));
            LocalDate checkOut = Objects.requireNonNull(DateUtils.toLocalDate((Date)HotelProductHelper.getCheckOutDate((HotelProduct)product)));
            result.setOffer(HotelsConverterHelper.convertHotelOffer(null, offer, this.isAgency, price, clientRef, persons, Collections.emptyList(), this.bookingFileRef, false, checkIn, checkOut));
        }
        result.setTicketNumber(product.getSystemNumber());
        result.setRefundable(this.isValidOnlineBooking && HotelsReservationHelper.isRefundAvailable((HotelProduct)product));
        result.setNotConfirmedAdditionalServices(!product.getNotConfirmedAdditionalServices().isEmpty());
        result.setShowRoomInfo(product.getNextProduct() == null);
        return result;
    }
}

