/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.PlacingData;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Carriage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayMcoService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainSegment;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class RailwayReservationBuilder
extends BaseReservationBuilder<RailwayReservation> {
    private static final Set<ReservationStatus> INTENTION_RESERVATION_STATUSES = EnumSet.of(ReservationStatus.INTENTION, ReservationStatus.PROPOSAL);

    @Override
    protected RailwayReservation getInstance() {
        return new RailwayReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.RAILWAY;
    }

    RailwayReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    @Override
    protected void updateReservationData(RailwayReservation result) throws Exception {
        super.updateReservationData(result);
        if (this.gdsAccountCtr != null) {
            result.setGdsAccount(CommonRailRestHelper.convertGdsAccountToRest((EntityReference<? extends BaseGdsAccount>)this.gdsAccountCtr.toReference()));
        }
        result.setShowGdsAccountName(this.siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_RAILWAY));
        boolean ancillaryFeesExists = BookingStreamHelper.getProductsStream((Reservation)this.reservation, RailwayProduct.class).anyMatch(rp -> !rp.getImData().getAvailableAncillaryFees().isEmpty());
        result.setGetAncillaryFeesAvailable(this.reservation.getStatus() == ReservationStatus.BOOKING && ancillaryFeesExists);
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, RailwayProduct.class).filter(this::availableProduct).collect(Collectors.toList());
        List services = result.getServices();
        products.stream().map(this::convertRailwayProduct2RailwayService).forEach(services::add);
        BookingStreamHelper.getProductsStream((Reservation)this.reservation, RailwayMcoProduct.class).map(this::convertToRailwayMcoService).filter(Objects::nonNull).forEach(result.getMcoServices()::add);
        boolean isIntentionReservation = INTENTION_RESERVATION_STATUSES.contains(this.reservation.getStatus());
        PlacingRequirements plReq = isIntentionReservation ? ApprovalHelper.getRailIntentionPlacingRequirements(this.reservation) : null;
        PlacingData plData = isIntentionReservation ? ApprovalHelper.getRailIntentionPlacingData(this.reservation) : null;
        try {
            TreeMap<Date, List<BaseProduct>> directionProductsMap = this.buildDirectionProductsMap();
            for (List<BaseProduct> baseProducts : directionProductsMap.values()) {
                List<RailwayProduct> railwayProducts = BookingStreamHelper.getProductsStream(baseProducts.stream(), RailwayProduct.class).collect(Collectors.toList());
                Carriage restCarriage = this.buildRestCarriage(railwayProducts, plReq, this.reservation.getBookingFile().getNumber());
                if (restCarriage == null) continue;
                if (plData != null) {
                    plData.getCarPlaceData().stream().map(cpd -> {
                        CarPlaceTypeData restCpd = new CarPlaceTypeData();
                        restCpd.setCarPlaceType(cpd.getCarPlaceType());
                        restCpd.getAvailableSeats().addAll(cpd.getAvailableSeats());
                        return restCpd;
                    }).forEach(restCarriage.getCarPlaceData()::add);
                }
                result.getCarriages().add(restCarriage);
            }
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error while building rest carriages. ", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private TreeMap<Date, List<BaseProduct>> buildDirectionProductsMap() {
        TreeMap<Date, List<BaseProduct>> directionProductsMap = new TreeMap<Date, List<BaseProduct>>();
        this.reservation.getProducts().stream().filter(this::isAppropriate).filter(bp -> ProductHandler.of((BaseProduct)bp).getRelatedProducts(bp).isEmpty()).forEach(bp -> {
            Date departureDate = (Date)MiscUtil.guarded((Object)ProductHandler.of((BaseProduct)bp).findFirstTravelDate(bp), (Object)Date.from(Instant.ofEpochSecond(0L)));
            List products = (List)CollectionUtil.getFromMap((Map)directionProductsMap, (Object)departureDate, ArrayList::new);
            products.add(bp);
        });
        return directionProductsMap;
    }

    @Override
    protected void setPriceData(RailwayReservation result) {
        TreeMap<Date, List<BaseProduct>> directionProductsMap = this.buildDirectionProductsMap();
        Iterator<List<BaseProduct>> iterator = directionProductsMap.values().iterator();
        List<BaseProduct> forwardProducts = iterator.next();
        ArrayList backProducts = new ArrayList();
        if (iterator.hasNext()) {
            backProducts.addAll(iterator.next());
        }
        if (iterator.hasNext()) {
            IncidentsLog.reportStackTrace((String)("railway reservation directionProductsMap size = " + directionProductsMap.values().size() + " in booking " + this.reservation.getBookingFile().getNumber() + ", reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation)));
        }
        this.reservation.getProducts().stream().filter(this::isAppropriate).forEach(bp -> {
            List relatedProducts = ProductHandler.of((BaseProduct)bp).getRelatedProducts(bp);
            if (!relatedProducts.isEmpty()) {
                if (CollectionUtil.containAtLeastOneCommonElement((Collection)relatedProducts, (Collection)forwardProducts)) {
                    forwardProducts.add((BaseProduct)bp);
                } else if (CollectionUtil.containAtLeastOneCommonElement((Collection)relatedProducts, (Collection)backProducts)) {
                    backProducts.add(bp);
                } else {
                    IncidentsLog.reportStackTrace((String)("railway reservation has non-directional product " + bp.getUid() + " in booking " + this.reservation.getBookingFile().getNumber() + ", reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation)));
                }
            }
        });
        result.setPrice(ReservationPriceComponents.builder(this.reservation, this.priceComponentsParameters).setProductFilter(forwardProducts::contains).build().createPrice());
        if (!backProducts.isEmpty()) {
            result.setPriceBack(ReservationPriceComponents.builder(this.reservation, this.priceComponentsParameters).setProductFilter(backProducts::contains).build().createPrice());
        }
        result.setTotalPrice(B2BRestHelper.calcTotalMoney(result.getPrice(), result.getPriceBack()));
    }

    private RailwayService convertRailwayProduct2RailwayService(RailwayProduct product) {
        ProductStatus status;
        RailwayService result = new RailwayService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        result.setTicketNumber(product.getSystemNumber());
        result.setRefundable(this.isValidOnlineBooking && RzdCommonHelper.isRefundAvailable((RailwayProduct)product));
        result.setERegisterApplied(RzdCommonHelper.isHasEReg((RailwayProduct)product));
        result.setChangeERegAvailable(this.isValidOnlineBooking && RzdCommonHelper.isERegAvailable((RailwayProduct)product));
        result.setVoucherPrinted(RzdCommonHelper.isVoucherPrinted((RailwayProduct)product));
        result.setChangePrepaidMealAvailable(RzdCommonHelper.isChangePrepaidMealAvailable((RailwayProduct)product));
        if (product.getRefundExpireDate() != null) {
            result.setRefundExpireDate(CommonHelper.getCorrectTime(product.getRefundExpireDate(), this.generalSettings));
        }
        if (product.getMealInfo() != null) {
            result.setMealInfo(CommonConverterHelper.convertMealOption2Rest(product.getMealInfo()));
        }
        result.setPaymentType((PaymentType)(ProductStatus.INTENTION == (status = product.getStatus()) || ProductStatus.BOOKING == status ? product.getPaymentType() : null));
        return result;
    }

    private RailwayMcoService convertToRailwayMcoService(RailwayMcoProduct product) {
        RailwayMcoService result = new RailwayMcoService();
        this.fillCommonProductData((Service)result, (BaseProduct)product, true);
        result.setGdsId(product.getGdsId());
        if (!product.getRelatedProducts().isEmpty()) {
            result.setMainServiceUid(((RailwayProduct)product.getRelatedProducts().get(0)).getUid());
        }
        result.setMcoCategory(product.getMcoCategory());
        result.setMcoNumber(product.getSystemNumber());
        XtripPriceStructure priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)true);
        result.setPrice(CommonConverterHelper.convertMoney2Rest(priceStructure.getTotal(), this.priceComponentsParameters.getCurrency()));
        result.setCancelAllowed(product.getStatus() == ProductStatus.BOOKING);
        return result;
    }

    private Carriage buildRestCarriage(List<RailwayProduct> products, PlacingRequirements plReq, String orderNumber) throws Exception {
        if (products.isEmpty()) {
            return null;
        }
        List segments = products.get(0).getSegments();
        if (CollectionUtil.isEmpty((Collection)segments)) {
            return null;
        }
        Carriage result = new Carriage();
        RailwaySegment segment = (RailwaySegment)segments.get(0);
        result.setNumber(segment.getCarriageNumber());
        result.setType(segment.getCarriageType());
        result.setCarriageCardId(segment.getCarriageCardId());
        result.setTrainBrand(segment.getBrand());
        result.setTrainCategory(segment.getTrainCategory());
        result.setERegEnabled(segment.isERegEnabled());
        result.setNonRefundableTariff(segment.isHasNonRefundableTariff());
        result.setTwoStoreyed(BooleanUtils.isTrue((Boolean)segment.getTwoFloors()));
        result.setProviderCarSchemeId(segment.getProviderCarSchemeId());
        RailwayServiceClass railwayServiceClass = CommonRailRestHelper.getRailwayServiceClass(segment.getServiceClass(), (DictionaryReference<RailwayCarrier>)segment.getCarrier(), segment.getTrainNumber(), ", \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430: " + orderNumber);
        result.getServices().addAll(CommonRailRestHelper.collectRailServices(railwayServiceClass, segment.getCarrierSubcategory(), segment.getServicesList()));
        if (railwayServiceClass == null) {
            railwayServiceClass = new RailwayServiceClass();
            railwayServiceClass.setServiceClass(segment.getServiceClass());
        }
        result.setServiceClass(CommonRailRestHelper.convertRailwayServiceClassToRest(railwayServiceClass));
        result.setSegment(this.convertRailwaySegment2TrainSegment(segment));
        if (plReq != null && plReq.getSeatRangeFirst() != null && plReq.getSeatRangeLast() != null) {
            for (int placeNmb = plReq.getSeatRangeFirst().intValue(); placeNmb <= plReq.getSeatRangeLast(); ++placeNmb) {
                result.getPlaces().add(String.valueOf(placeNmb));
            }
        } else {
            products.forEach(prod -> result.getPlaces().addAll(((RailwaySegment)prod.getSegments().get(0)).getPlaces()));
        }
        result.setTrain(this.getTrain(products.get(0).getReservation(), segment));
        return result;
    }

    private TrainSegment convertRailwaySegment2TrainSegment(RailwaySegment segment) {
        TrainSegment result = new TrainSegment();
        result.setDepartureDate(DateUtils.toLocalDateTime((Date)segment.getDepartureDate()));
        result.setArrivalDate(DateUtils.toLocalDateTime((Date)segment.getArriveDate()));
        result.setLocalDepartureDate(DateUtils.toLocalDateTime((Date)segment.getLocalDepartureDate()));
        result.setLocalArrivalDate(DateUtils.toLocalDateTime((Date)segment.getLocalArriveDate()));
        result.setDepartureMoscowTimeZone(RzdCommonHelper.isRussiaStation((DictionaryReference)segment.getDepartureStation()));
        result.setArrivalMoscowTimeZone(RzdCommonHelper.isRussiaStation((DictionaryReference)segment.getArriveStation()));
        result.setCarWithOtherArrivalTimeExists(segment.getTrainArriveToStationDate() != null && !MiscUtil.equals((Object)segment.getTrainArriveToStationDate(), (Object)segment.getArriveDate()));
        result.setDepartureLocation(segment.getDepartureStation());
        result.setArrivalLocation(segment.getArriveStation());
        result.setTrainDepartureLocation(segment.getDepartureLocation());
        result.setTrainArrivalLocation(segment.getArrivalLocation());
        result.setDurationInMinutes(segment.getDurationInMinutes());
        result.setTrainNumber(segment.getTrainNumberInSearch());
        return result;
    }

    private Train getTrain(Reservation reservation, RailwaySegment railwaySegment) throws Exception {
        Train result = new Train();
        if (this.gdsAccountCtr != null) {
            result.setGds(((BaseGdsAccount)this.gdsAccountCtr.getEntity()).getGds());
        }
        RestTrainToken token = new RestTrainToken();
        if (this.gdsAccountCtr != null) {
            token.setGdsAccount(this.gdsAccountCtr.toReference());
        }
        token.setTrainNumber(railwaySegment.getTrainNumberInSearch());
        token.setClient(reservation.getBookingFile().getCustomerProfile());
        result.setToken(CommonRestHelper.encodeToken((BaseEntity)token));
        TrainSegment segment = new TrainSegment();
        segment.setDepartureLocation(railwaySegment.getDepartureStation());
        segment.setArrivalLocation(railwaySegment.getArriveStation());
        segment.setDepartureDate(DateUtils.toLocalDateTime((Date)railwaySegment.getDepartureDate()));
        result.getSegments().add(segment);
        return result;
    }
}

