/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.Car;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PassengersTypes;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransferReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransferService;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class TransferReservationBuilder
extends BaseReservationBuilder<TransferReservation> {
    @Override
    protected TransferReservation getInstance() {
        return new TransferReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        return ProductHandler.of((BaseProduct)bp).findTravelSubject(bp) == TravelSubject.TRANSFER;
    }

    TransferReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
    }

    @Override
    protected void updateReservationData(TransferReservation result) throws Exception {
        super.updateReservationData(result);
        result.setShowGdsAccountName(this.siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_TRANSFERS));
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, Transfer.class).filter(this::availableProduct).collect(Collectors.toList());
        List services = result.getServices();
        products.stream().map(this::convertTransferProduct2TransferService).forEach(services::add);
        if (!products.isEmpty()) {
            Transfer transfer = (Transfer)products.get(0);
            result.setCar(this.buildRestCar(transfer));
            result.setStartAddress(transfer.getStartAddress());
            result.setEndAddress(transfer.getEndAddress());
            result.getSubAddresses().addAll(transfer.getSubAddresses());
            result.setPickUpTime(MiscUtil.toLocalDateTime((Date)transfer.getStartDate()));
            if (transfer.getCancellationNoPenaltyHours() != null) {
                result.setCancellationNoPenaltyHours(transfer.getCancellationNoPenaltyHours().intValue());
            }
            result.setFlexibleTariff(transfer.isFlexibleTariff());
            result.setFlexibleTariffAgreement(transfer.isFlexibleTariffAgreement());
            PassengersTypes passengersTypes = new PassengersTypes();
            passengersTypes.setADULT(transfer.getAdultCount() != null ? transfer.getAdultCount() : 0);
            passengersTypes.setCHILD(transfer.getChildCount() != null ? transfer.getChildCount() : 0);
            result.setPassengersTypes(passengersTypes);
            result.setTransferType(transfer.getTransferType());
        }
    }

    private TransferService convertTransferProduct2TransferService(Transfer product) {
        TransferService result = new TransferService();
        this.fillCommonProductData((Service)result, (BaseProduct)product);
        result.setTicketNumber(product.getSystemNumber());
        result.setPassengersCount(MiscUtil.guarded((Integer)product.getPassengersCount()).intValue());
        result.setRefundable(this.isValidOnlineBooking && BookingConverterHelper.isRefundAvailable(product));
        return result;
    }

    private Car buildRestCar(Transfer transfer) {
        Car car = new Car();
        car.setCarClass(transfer.getCarClass());
        car.setModels(transfer.getAddInfo().getCarModels());
        car.setImageUrl(transfer.getAddInfo().getCarImageUrl());
        car.setCapacity(MiscUtil.guarded((Integer)transfer.getAddInfo().getCarCapacity()).intValue());
        return car;
    }
}

