/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingPermissions;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingInfo.BaseReservationBuilder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RestUniversalCustomValue;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.Service;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.UniversalReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.UniversalService;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class UniversalReservationBuilder
extends BaseReservationBuilder<UniversalReservation> {
    private final EntityReference<UniversalProductDescription> descRef;

    @Override
    protected UniversalReservation getInstance() {
        return new UniversalReservation();
    }

    @Override
    protected boolean isAppropriate(BaseProduct bp) {
        if (!(bp instanceof UniversalProduct)) {
            return false;
        }
        UniversalProduct up = (UniversalProduct)bp;
        return MiscUtil.equals(this.descRef, (Object)up.getDescription());
    }

    UniversalReservationBuilder(Reservation reservation, SMGeneralSettings generalSettings, BookingPermissions permissions, PriceComponentsParameters priceComponentsParameters, EntityReference<UniversalProductDescription> descRef) {
        super(reservation, generalSettings, permissions, priceComponentsParameters);
        this.descRef = descRef;
    }

    @Override
    protected void updateReservationData(UniversalReservation result) throws Exception {
        super.updateReservationData(result);
        List products = BookingStreamHelper.getProductsStream((Reservation)this.reservation, UniversalProduct.class).filter(this::isAppropriate).filter(this::availableProduct).collect(Collectors.toList());
        EntityContainer descCtr = EntityStorage.get().resolve(this.descRef);
        if (descCtr == null) {
            IncidentsLog.reportStackTrace((String)("broken universal product description ref: booking " + this.reservation.getBookingFile().getNumber() + ", reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation) + ", descRef " + this.descRef));
            return;
        }
        UniversalProductDescription desc = (UniversalProductDescription)descCtr.getEntity();
        for (UniversalProduct product : products) {
            if (TextUtil.isBlank((String)result.getUniversalProductDesc())) {
                result.setUniversalProductDesc(desc.toString());
            }
            UniversalService restService = new UniversalService();
            this.fillCommonProductData((Service)restService, (BaseProduct)product);
            restService.setTicketNumber(product.getSystemNumber());
            desc.getCustomParameters().stream().filter(UniversalProductCustomParameterDescription::isRequired).map(paramDesc -> this.convertToCustomValue((UniversalProductCustomParameterDescription)paramDesc, product)).forEach(restService.getCustomValues()::add);
            result.getServices().add(restService);
        }
    }

    private RestUniversalCustomValue convertToCustomValue(UniversalProductCustomParameterDescription paramDesc, UniversalProduct product) {
        Object value;
        RestUniversalCustomValue result = new RestUniversalCustomValue();
        result.setId(paramDesc.getId());
        result.setName(paramDesc.getDisplayName());
        result.setType(paramDesc.getType());
        UniversalProductCustomParameter productParameter = product.getCustomParameters().stream().filter(cp -> MiscUtil.equals((Object)cp.getId(), (Object)paramDesc.getId())).findFirst().orElse(null);
        Object object = value = productParameter != null ? productParameter.getValue() : null;
        if (value != null && paramDesc.getType() != null) {
            try {
                switch (paramDesc.getType()) {
                    case NUMBER: {
                        BigDecimal val = (BigDecimal)value;
                        result.setNumberValue(val);
                        break;
                    }
                    case DATE: {
                        Date val = (Date)value;
                        result.setDateValue(DateUtils.toLocalDate((Date)val));
                        break;
                    }
                    case DATE_TIME: {
                        Date val = (Date)value;
                        result.setDateTimeValue(DateUtils.toLocalDateTime((Date)val));
                        break;
                    }
                    case DICTIONARY: {
                        DictionaryReference val = (DictionaryReference)value;
                        result.setRefValue(val);
                        break;
                    }
                    case BOOLEAN: {
                        Boolean val = (Boolean)value;
                        result.setBooleanValue(val);
                        break;
                    }
                    default: {
                        this.setStringValue(result, value);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                IncidentsLog.reportException((String)"convert universal product value to rest failed", (Throwable)ex);
                this.setStringValue(result, value);
            }
        }
        return result;
    }

    private void setStringValue(RestUniversalCustomValue result, Object value) {
        result.setType(UniversalProductCustomParameterType.STRING);
        result.setStringValue(value.toString());
    }
}

