/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.xtrip.common.ibecorp.exception.NotEnoughFundsOnBalanceException;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b.IbecorpPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.initiatePayment.InitiatePGPaymentProcessor;
import java.math.BigDecimal;

public class B2BInitiatePGPaymentProcessor
extends InitiatePGPaymentProcessor {
    @Override
    protected void checkTicketingPermission(SalesContext salesContext, BigDecimal bookingPrice) {
        if (bookingPrice == null) {
            throw Xeption.forDeveloper((String)L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_BOOKING_PRICE", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        EntityReference clientRef = salesContext.getClient();
        EntityReference subagencyRef = salesContext.getSubagency();
        EntityReference agencyRef = salesContext.getAgency();
        BigDecimal balance = IbecorpPaymentHelper.getBalance((EntityReference<Organization>)agencyRef, (EntityReference<Organization>)subagencyRef, (EntityReference<Organization>)clientRef);
        if (balance == null) {
            throw Xeption.forDeveloper((String)L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_ORGANIZATION_BALANCE", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (bookingPrice.compareTo(balance) > 0) {
            throw new NotEnoughFundsOnBalanceException();
        }
    }
}

