/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.ibecorp.booking.MultiReservationData;
import com.gridnine.xtrip.common.model.ibecorp.booking.MultiReservationItem;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Objects;

public class B2BPrepareMultiReservationDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        MultiReservationData data = new MultiReservationData();
        LinkedHashMap<SalesContext, MultiReservationItem> map = new LinkedHashMap<SalesContext, MultiReservationItem>();
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        for (Reservation reservation : MidofficeHelper.getReservations((EntityContainer)bfCtr, (Collection)reservations)) {
            SalesContext sc;
            Product product = GDSHelper.getProductsStream((Reservation)Objects.requireNonNull(reservation)).findFirst().orElse(null);
            EntityReference sp = salesContext.getSalesPoint();
            if (product != null) {
                RuleProxy proxy = new RuleProxy();
                proxy.setProxyType(Targets.GDS_PARAMETERS_EX.getId());
                proxy.setProxyDate(new Date());
                proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
                ((GdsProductPropertySet)proxy.getPropertySet()).init(product);
                proxy.setActionSet((Object)new GDSParametersActions());
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
                sp = ((GDSParametersActions)proxy.getActionSet()).getTicketingPCCRef();
            }
            if (Objects.equals(sp, salesContext.getSalesPoint())) {
                sc = salesContext;
            } else {
                sc = (SalesContext)XCloneHelper.clone((XCloneable)salesContext, (boolean)true);
                sc.setSalesPoint(sp);
            }
            MultiReservationItem item = (MultiReservationItem)map.get(sc);
            if (null == item) {
                item = new MultiReservationItem();
                item.setSalesContext(sc);
                data.getItems().add(item);
                map.put(sc, item);
            }
            item.getReservations().add(reservation);
        }
        ctx.putObject((Enum)IBusIbecorpContextKeys.MULTI_RESERVATION_DATA, (Object)data);
    }
}

