/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.B2BInitiatePaymentParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RepriceBookingResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class B2BRepriceBookingResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        B2BInitiatePaymentParameters parameters = (B2BInitiatePaymentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        EntityContainer bookingFileEntityContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_CONTAINER);
        Collection reservations = MidofficeHelper.getReservations((EntityContainer)bookingFileEntityContainer, (Collection)((Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS)));
        InitiatePaymentResult result = new InitiatePaymentResult();
        BigDecimal oldPrice = parameters.getVisiblePrice();
        String currency = PriceComponentsParameters.getBriefInfoParameters(salesContext).getCurrency();
        Money oldMoney = CommonConverterHelper.convertMoney2Rest(oldPrice, currency);
        this.actualizePrice((EntityContainer<BookingFile>)bookingFileEntityContainer, reservations, paymentType);
        BigDecimal newPrice = PaymentHelper.getPaymentPrice((Collection)reservations, (ContractType)ContractType.CLIENT, null, null);
        Money newMoney = CommonConverterHelper.convertMoney2Rest(newPrice, currency);
        if (!MiscUtil.equals((Object)oldMoney.getAmount(), (Object)newMoney.getAmount())) {
            RepriceBookingResult repriceResult = new RepriceBookingResult();
            repriceResult.setPriceChanged(true);
            repriceResult.setOldPrice(oldMoney);
            repriceResult.setNewPrice(newMoney);
            result.getPriceChangeInfo().put("booking", repriceResult);
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            ctx.putObject((Enum)IBusIbecorpContextKeys.PRICE_CHANGED, (Object)true);
        }
    }

    private void actualizePrice(EntityContainer<BookingFile> bookingFileEntityContainer, Collection<Reservation> reservations, PaymentType paymentType) {
        reservations.stream().flatMap(res -> res.getProducts().stream()).forEach(baseProduct -> {
            List generalProductContractRelationData = GeneralProductHelper.copyContractRelations((BaseProduct)baseProduct);
            generalProductContractRelationData.stream().flatMap(data -> data.getFops().stream()).forEach(fop -> fop.setType(paymentType));
            ProductHandler handler = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)baseProduct));
            handler.updateContractRelations(baseProduct, generalProductContractRelationData);
        });
        BookingCommissionsCalculator bookingCommissionsCalculator = (BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class);
        ArrayList messages = new ArrayList();
        HashMap params = new HashMap();
        DebugInfo debugInfo = new DebugInfo();
        try {
            bookingCommissionsCalculator.applyRules(bookingFileEntityContainer, true, true, messages, params, debugInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

