/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CheckTicketingPermissionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        List<List<Reservation>> list = this.createReservationsDependOnContext(reservations);
        for (List<Reservation> reservationsFromSameContext : list) {
            BigDecimal bookingPrice = PaymentHelper.getPaymentPrice((Collection)MidofficeHelper.getReservations((EntityContainer)bookingFileCtr, reservationsFromSameContext), (ContractType)ContractType.CLIENT, null, null);
            Reservation reservation = reservationsFromSameContext.get(0);
            B2BRestHelper.checkBalance((EntityContainer<BookingFile>)bookingFileCtr, reservation, bookingPrice, paymentType, "ticketing");
        }
    }

    private List<List<Reservation>> createReservationsDependOnContext(Collection<Reservation> reservations) {
        HashMap<String, List> helpMap = new HashMap<String, List>();
        for (Reservation reservation : reservations) {
            List<Reservation> list;
            SalesContext context = SalesContextHandler.get().createSalesContext(reservation);
            String key = this.initKey(context);
            if (helpMap.containsKey(key)) {
                list = (List)helpMap.get(key);
                list.add(reservation);
                helpMap.put(key, list);
                continue;
            }
            list = new ArrayList();
            ((ArrayList)list).add(reservation);
            helpMap.put(key, list);
        }
        ArrayList<List<Reservation>> list = new ArrayList<List<Reservation>>();
        helpMap.forEach((k, v) -> list.add((List<Reservation>)v));
        return list;
    }

    private String initKey(SalesContext context) {
        return context.getSubagency().getUid() + "_" + context.getAgency().getUid() + "_" + context.getClient().getUid() + "_" + context.getAgent().getUid();
    }
}

