/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IbecorpPaymentHelper {
    public static final String RESERVATIONS_TO_PAY_BOOKING_KEY = "booking";

    public static List<Reservation> getReservations(BookingFile booking, Map<String, BigDecimal> reservationsToPay) {
        if (reservationsToPay.isEmpty()) {
            return null;
        }
        List allReservationUids = booking.getReservations().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
        List invalidUids = reservationsToPay.keySet().stream().filter(payUid -> !allReservationUids.contains(payUid)).collect(Collectors.toList());
        if (!invalidUids.isEmpty()) {
            throw Xeption.forDeveloper((String)"invalid uids in reservationsToPay: {0}", (Object[])new Object[]{invalidUids});
        }
        return booking.getReservations().stream().filter(r -> reservationsToPay.containsKey(r.getUid())).collect(Collectors.toList());
    }

    public static Map<String, BigDecimal> correctReservationsToPay(Map<String, BigDecimal> reservationsToPay) {
        if (reservationsToPay.isEmpty()) {
            return null;
        }
        return reservationsToPay;
    }

    public static BigDecimal getBalance(EntityReference<Organization> agencyRef, EntityReference<Organization> subagencyRef, EntityReference<Organization> clientRef) {
        BigDecimal balance;
        Organization client = (Organization)EntityStorage.get().resolve(clientRef).getEntity();
        String clientCurrencyCode = null;
        if (agencyRef.equals(subagencyRef)) {
            balance = BigDecimal.valueOf(Double.MAX_VALUE);
        } else {
            String subagencyCurrencyCode = CurrencyHelper.getCurrency(agencyRef, subagencyRef, (ContractType)ContractType.SUBAGENCY);
            DictionaryReference subagencyCurrency = FinanceHelper.getCurrency((String)subagencyCurrencyCode);
            balance = IbecorpPaymentHelper.getBalanceWithCredit(subagencyRef, agencyRef, (DictionaryReference<CurrencyInfo>)subagencyCurrency);
            if (BigDecimal.ZERO.compareTo(balance) != 0) {
                clientCurrencyCode = CurrencyHelper.getCurrency(subagencyRef, clientRef, (ContractType)ContractType.CLIENT);
                balance = CurrencyHelper.exchange((BigDecimal)balance, (String)subagencyCurrencyCode, (String)clientCurrencyCode);
            }
        }
        if (!TextUtil.isSame((String)client.getCode(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null))) {
            if (clientCurrencyCode == null) {
                clientCurrencyCode = CurrencyHelper.getCurrency(subagencyRef, clientRef, (ContractType)ContractType.CLIENT);
            }
            DictionaryReference clientCurrency = FinanceHelper.getCurrency(clientCurrencyCode);
            balance = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{balance, IbecorpPaymentHelper.getBalanceWithCredit(clientRef, subagencyRef, (DictionaryReference<CurrencyInfo>)clientCurrency)});
        }
        return balance;
    }

    private static BigDecimal getBalanceWithCredit(EntityReference<Organization> customer, EntityReference<Organization> supplier, DictionaryReference<CurrencyInfo> currency) {
        CreditLimitInfo creditLimitInfo = ProfileHelper.getOrganizationCreditLimit(customer, supplier);
        if (creditLimitInfo != null && creditLimitInfo.isUnlimited()) {
            return BigDecimal.valueOf(Double.MAX_VALUE);
        }
        Map<DimensionType, EntityReference<Organization>> dimensionTypeObjectMap = Collections.singletonMap(DimensionType.ORGANIZATION, supplier);
        BigDecimal balance = BalanceHelper.calculateBalance(customer, null, null, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, currency, dimensionTypeObjectMap);
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{balance, ProfileHelper.getCreditAmount((CreditLimitInfo)creditLimitInfo)});
    }
}

